/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivelib.common.block.IMultiBlockPeripheral;
import cy.jdkdigital.productivelib.util.ImmutableFluidStack;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTankBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FoundryTankBlock
extends BaseEntityBlock
implements IMultiBlockPeripheral {
    public static final MapCodec<FoundryTankBlock> CODEC = FoundryTankBlock.simpleCodec(FoundryTankBlock::new);

    public FoundryTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FoundryTankBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : FoundryTankBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)MetalworksRegistrator.FOUNDRY_TANK_BLOCK_ENTITY.get()), FoundryTankBlockEntity::serverTick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ImmutableFluidStack fluid;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.has(MetalworksRegistrator.FLUID_STACK.get()) && (fluid = (ImmutableFluidStack)stack.get(MetalworksRegistrator.FLUID_STACK.get())) != null) {
            tooltipComponents.add((Component)Component.translatable((String)"block.productivemetalworksfoundry_tank.fluid_tooltip", (Object[])new Object[]{fluid.fluid().getAmount(), Component.translatable((String)fluid.fluid().getFluidType().getDescriptionId())}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FoundryTankBlockEntity) {
            FoundryTankBlockEntity blockEntity2 = (FoundryTankBlockEntity)blockEntity;
            if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                if (level instanceof ServerLevel) {
                    BlockEntity blockEntity3;
                    BlockEntity blockEntity4;
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)blockEntity2.getFluidHandler());
                    int j = 1;
                    while ((blockEntity4 = level.getBlockEntity(pos.below(j))) instanceof FoundryTankBlockEntity) {
                        FoundryTankBlockEntity tank = (FoundryTankBlockEntity)blockEntity4;
                        if (j >= 50) break;
                        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank.getFluidHandler());
                        ++j;
                    }
                    int i = 1;
                    while ((blockEntity3 = level.getBlockEntity(pos.above(i))) instanceof FoundryTankBlockEntity) {
                        FoundryTankBlockEntity tank = (FoundryTankBlockEntity)blockEntity3;
                        if (i >= 50) break;
                        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank.getFluidHandler());
                        ++i;
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

