/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.util;

import cy.jdkdigital.productivelib.util.MultiFluidTank;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.event.CastingRecipeEvent;
import cy.jdkdigital.productivemetalworks.recipe.BlockCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.fluids.FluidStack;

public class RecipeHelper {
    static Map<String, RecipeHolder<ItemMeltingRecipe>> itemMeltingRecipeCache = new HashMap<String, RecipeHolder<ItemMeltingRecipe>>();
    static Map<String, RecipeHolder<ItemCastingRecipe>> itemCastingRecipeCache = new HashMap<String, RecipeHolder<ItemCastingRecipe>>();
    static Map<String, RecipeHolder<BlockCastingRecipe>> blockCastingRecipeCache = new HashMap<String, RecipeHolder<BlockCastingRecipe>>();
    static List<RecipeHolder<FluidAlloyingRecipe>> alloyRecipes = new ArrayList<RecipeHolder<FluidAlloyingRecipe>>();
    static Map<String, ItemCastingRecipe> compatCastingRecipeCache = new HashMap<String, ItemCastingRecipe>();

    @Nullable
    public static RecipeHolder<ItemMeltingRecipe> getItemMeltingRecipe(Level level, ItemStack item, @Nullable FuelMap fuelData) {
        if (fuelData == null) {
            return null;
        }
        String cacheKey = RecipeHelper.itemCacheKey(item) + fuelData.temperature();
        if (!itemMeltingRecipeCache.containsKey(cacheKey)) {
            for (RecipeHolder recipeHolder : level.getRecipeManager().getAllRecipesFor((RecipeType)MetalworksRegistrator.ITEM_MELTING_TYPE.get())) {
                if (!((ItemMeltingRecipe)recipeHolder.value()).matches(item, fuelData.temperature())) continue;
                itemMeltingRecipeCache.put(cacheKey, (RecipeHolder<ItemMeltingRecipe>)new RecipeHolder(recipeHolder.id(), (Recipe)((ItemMeltingRecipe)recipeHolder.value())));
            }
        }
        return itemMeltingRecipeCache.getOrDefault(cacheKey, null);
    }

    @Nullable
    public static RecipeHolder<ItemCastingRecipe> getItemCastingRecipe(Level level, ItemStack cast, FluidStack fluid) {
        String cacheKey = RecipeHelper.itemCacheKey(cast) + RecipeHelper.fluidCacheKey(fluid);
        if (!itemCastingRecipeCache.containsKey(cacheKey)) {
            for (RecipeHolder recipeHolder : level.getRecipeManager().getAllRecipesFor((RecipeType)MetalworksRegistrator.ITEM_CASTING_TYPE.get())) {
                if (!((ItemCastingRecipe)recipeHolder.value()).matches(cast, fluid, level)) continue;
                itemCastingRecipeCache.put(cacheKey, (RecipeHolder<ItemCastingRecipe>)recipeHolder);
            }
        }
        return itemCastingRecipeCache.getOrDefault(cacheKey, null);
    }

    @Nullable
    public static RecipeHolder<BlockCastingRecipe> getBlockCastingRecipe(Level level, ItemStack cast, FluidStack fluid) {
        String cacheKey = RecipeHelper.itemCacheKey(cast) + RecipeHelper.fluidCacheKey(fluid);
        if (!blockCastingRecipeCache.containsKey(cacheKey)) {
            for (RecipeHolder recipeHolder : level.getRecipeManager().getAllRecipesFor((RecipeType)MetalworksRegistrator.BLOCK_CASTING_TYPE.get())) {
                if (!((BlockCastingRecipe)recipeHolder.value()).matches(cast, fluid, level)) continue;
                blockCastingRecipeCache.put(cacheKey, (RecipeHolder<BlockCastingRecipe>)recipeHolder);
            }
        }
        return blockCastingRecipeCache.getOrDefault(cacheKey, null);
    }

    public static List<RecipeHolder<FluidAlloyingRecipe>> getAlloyRecipes(Level level, MultiFluidTank fluidHandler) {
        if (alloyRecipes.isEmpty()) {
            alloyRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)MetalworksRegistrator.FLUID_ALLOYING_TYPE.get());
        }
        ArrayList<FluidStack> availableFluids = new ArrayList<FluidStack>();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidStack = fluidHandler.getFluidInTank(tank);
            if (fluidStack.isEmpty()) continue;
            availableFluids.add(fluidStack);
        }
        ArrayList<RecipeHolder<FluidAlloyingRecipe>> recipeProcessList = new ArrayList<RecipeHolder<FluidAlloyingRecipe>>();
        for (RecipeHolder<FluidAlloyingRecipe> recipeHolder : alloyRecipes) {
            if (!((FluidAlloyingRecipe)recipeHolder.value()).matches(availableFluids)) continue;
            recipeProcessList.add(recipeHolder);
        }
        return recipeProcessList;
    }

    public static ItemCastingRecipe getCompatRecipe(Level level, ItemStack cast, FluidStack fluid, boolean isTable) {
        String cacheKey = RecipeHelper.itemCacheKey(cast) + RecipeHelper.fluidCacheKey(fluid) + (isTable ? "table" : "basin");
        if (!compatCastingRecipeCache.containsKey(cacheKey)) {
            CastingRecipeEvent event = new CastingRecipeEvent(level, cast, fluid, isTable);
            ModLoader.postEvent((Event)event);
            compatCastingRecipeCache.put(cacheKey, event.hasRecipe() ? event.getRecipe() : null);
        }
        return compatCastingRecipeCache.getOrDefault(cacheKey, null);
    }

    public static String itemCacheKey(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString() + String.valueOf(!stack.getComponents().isEmpty() ? stack.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
    }

    public static String fluidCacheKey(FluidStack stack) {
        return BuiltInRegistries.FLUID.getKey((Object)stack.getFluid()).toString() + String.valueOf(!stack.getComponents().isEmpty() ? stack.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
    }
}

