/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class TickingSlotInventoryHandler
extends InventoryHandlerHelper.BlockEntityItemStackHandler {
    List<Pair<Integer, Integer>> tickers;

    public TickingSlotInventoryHandler(int size, @Nullable BlockEntity blockEntity) {
        super(size, blockEntity);
        this.initTickers();
    }

    protected abstract int getTimeInSlot(ItemStack var1);

    public void setSize(int size) {
        super.setSize(size);
        if (size != this.size()) {
            this.initTickers();
            this.recalculate();
        }
    }

    protected void initTickers() {
        this.tickers = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < this.size(); ++i) {
            this.tickers.add((Pair<Integer, Integer>)Pair.of((Object)0, (Object)0));
        }
    }

    public void resetTicker(int slot) {
        if (slot < this.tickers.size()) {
            this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)0));
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean fromAutomation) {
        ItemStack returnStack = super.insertItem(slot, stack, simulate, fromAutomation);
        if (!simulate && returnStack.getCount() != stack.getCount() && slot < this.tickers.size()) {
            int time = this.getTimeInSlot(stack);
            this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)time, (Object)time));
        }
        return returnStack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (!stack.isEmpty() && slot < this.tickers.size() && this.blockEntity.hasLevel() && !this.blockEntity.getLevel().isClientSide) {
            int time = this.getTimeInSlot(stack);
            this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)time, (Object)time));
        }
        super.setStackInSlot(slot, stack);
        this.onContentsChanged(slot);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
        ItemStack returnStack = super.extractItem(slot, amount, simulate, fromAutomation);
        if (!simulate && !returnStack.isEmpty()) {
            this.resetTicker(slot);
        }
        return returnStack;
    }

    public void tick(int t) {
        for (int slot = 0; slot < this.tickers.size(); ++slot) {
            if (slot >= this.size()) continue;
            Pair<Integer, Integer> pair = this.tickers.get(slot);
            if ((Integer)pair.getSecond() > 0 && (Integer)pair.getFirst() > 0) {
                this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)Math.max((Integer)pair.getFirst() - t, 0), (Object)((Integer)pair.getSecond())));
            }
            if ((Integer)pair.getSecond() != 0 || !this.getStackInSlot(slot).isEmpty()) continue;
            this.recalculate(slot);
        }
    }

    public void recalculate() {
        for (int slot = 0; slot < this.tickers.size(); ++slot) {
            this.recalculate(slot);
        }
    }

    public void recalculate(int slot) {
        Pair<Integer, Integer> pair = this.tickers.get(slot);
        int time = this.getTimeInSlot(this.getStackInSlot(slot));
        this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)Math.max(time - ((Integer)pair.getSecond() - (Integer)pair.getFirst()), 0), (Object)time));
    }

    public Pair<Integer, Integer> getTicker(int slot) {
        return this.tickers.size() > slot ? this.tickers.get(slot) : Pair.of((Object)0, (Object)0);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        for (int slot = 0; slot < Math.min(this.size(), this.tickers.size()); ++slot) {
            if ((Integer)this.tickers.get(slot).getSecond() <= 0) continue;
            nbt.putInt("t" + slot + "_passed", ((Integer)this.tickers.get(slot).getFirst()).intValue());
            nbt.putInt("t" + slot + "_total", ((Integer)this.tickers.get(slot).getSecond()).intValue());
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.initTickers();
        for (int slot = 0; slot < this.size(); ++slot) {
            if (!nbt.contains("t" + slot + "_total") || slot >= this.tickers.size()) continue;
            int time = nbt.getInt("t" + slot + "_total");
            this.tickers.set(slot, (Pair<Integer, Integer>)Pair.of((Object)nbt.getInt("t" + slot + "_passed"), (Object)time));
        }
    }
}

