/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.context;

import java.util.List;
import java.util.Objects;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyFor(value=PhysicalSide.CLIENT)
public record DisplayContext(List<ItemStack> inventory) implements BotanyPotContext
{
    @Override
    public ItemStack getSoilItem() {
        return this.inventory.get(0);
    }

    @Override
    public ItemStack getSeedItem() {
        return this.inventory.get(1);
    }

    @Override
    public ItemStack getHarvestItem() {
        return this.inventory.get(2);
    }

    @Override
    public LootParams createLootParams(@Nullable BlockState state) {
        throw new IllegalStateException("Display context can not generate loot.");
    }

    @Override
    public void runFunction(ResourceLocation functionId) {
        throw new IllegalStateException("Display context can not run functions! Function=" + functionId.toString());
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public ItemStack getInteractionItem() {
        return this.getPlayer() != null ? this.getPlayer().getMainHandItem() : ItemStack.EMPTY;
    }

    @Override
    public int getRequiredGrowthTicks() {
        if (this.getPlayer() != null) {
            Level level = this.getPlayer().level();
            RecipeHolder soil = Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).lookup(this.getSoilItem(), this, level);
            RecipeHolder crop = Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).lookup(this.getSeedItem(), this, level);
            if (crop != null) {
                return Helpers.getRequiredGrowthTicks(this, level, (Crop)crop.value(), soil != null ? (Soil)soil.value() : null);
            }
        }
        return -1;
    }

    @Override
    public boolean isServerThread() {
        return false;
    }

    @Override
    @Nullable
    public Crop getCrop() {
        Level level;
        RecipeHolder crop;
        if (this.getPlayer() != null && (crop = Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level = this.getPlayer().level())).lookup(this.getSeedItem(), this, level)) != null) {
            return (Crop)crop.value();
        }
        return null;
    }

    @Override
    @Nullable
    public Soil getSoil() {
        Level level;
        RecipeHolder soil;
        if (this.getPlayer() != null && (soil = Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level = this.getPlayer().level())).lookup(this.getSoilItem(), this, level)) != null) {
            return (Soil)soil.value();
        }
        return null;
    }

    @NotNull
    public ItemStack getItem(int i) {
        return this.inventory.get(i);
    }

    public int size() {
        return this.inventory.size();
    }
}

