/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class RecipeCache<T extends BotanyPotRecipe> {
    private final Supplier<RecipeType<T>> recipeType;
    private final ReloadableCache<Map<ResourceLocation, RecipeHolder<T>>> recipeCache;
    private final Multimap<Item, RecipeHolder<T>> lookupCache = ArrayListMultimap.create();
    private final List<RecipeHolder<T>> uncached = new LinkedList<RecipeHolder<T>>();

    private RecipeCache(Supplier<RecipeType<T>> recipeType) {
        this.recipeType = recipeType;
        this.recipeCache = ReloadableCache.recipes(this.recipeType);
    }

    public boolean isCached(ItemStack stack) {
        return !stack.isEmpty() && !this.lookupCache.get((Object)stack.getItem()).isEmpty();
    }

    public Multimap<Item, RecipeHolder<T>> getCachedValues() {
        return this.lookupCache;
    }

    @Nullable
    public RecipeHolder<T> lookup(ItemStack stack, BotanyPotContext context, Level level) {
        if (stack.isEmpty()) {
            return null;
        }
        Collection cachedRecipes = this.lookupCache.get((Object)stack.getItem());
        for (RecipeHolder recipeHolder : this.lookupCache.get((Object)stack.getItem())) {
            if (!((BotanyPotRecipe)recipeHolder.value()).couldMatch(stack, context, level)) continue;
            return recipeHolder;
        }
        for (RecipeHolder recipeHolder : this.uncached) {
            if (!((BotanyPotRecipe)recipeHolder.value()).couldMatch(stack, context, level)) continue;
            return recipeHolder;
        }
        return null;
    }

    private void buildCache(Level level) {
        long startTime = System.nanoTime();
        Map recipes = (Map)this.recipeCache.apply(level);
        if (recipes == null) {
            BotanyPotsMod.LOG.error("Could not build {} cache. Entries do not exist?", this.recipeType.get());
            return;
        }
        this.uncached.clear();
        this.uncached.addAll(recipes.values());
        if (!recipes.isEmpty()) {
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack defaultStack = item.getDefaultInstance();
                for (RecipeHolder recipe : recipes.values()) {
                    CacheableRecipe cacheable;
                    Recipe recipe2 = recipe.value();
                    if (!(recipe2 instanceof CacheableRecipe) || !(cacheable = (CacheableRecipe)recipe2).canBeCached() || !cacheable.isCacheKey(defaultStack)) continue;
                    this.lookupCache.put((Object)item, (Object)recipe);
                    this.uncached.remove(recipe);
                }
            }
        }
        long endTime = System.nanoTime();
        BotanyPotsMod.LOG.info("Built {} {} cache in {}ms. {} / {} entries cached.", new Object[]{level.isClientSide ? "Client" : "Server", this.recipeType.get(), Float.valueOf((float)(endTime - startTime) / 1000000.0f), recipes.size() - this.uncached.size(), recipes.size()});
    }

    public static <T extends BotanyPotRecipe> SidedReloadableCache<RecipeCache<T>> of(Supplier<RecipeType<T>> type) {
        return SidedReloadableCache.of((T level) -> {
            RecipeCache cache = new RecipeCache(type);
            cache.buildCache((Level)level);
            return cache;
        });
    }
}

