/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.recipes.crop;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Crop
extends BotanyPotRecipe {
    public static final Supplier<RecipeType<Crop>> TYPE = CachedSupplier.of((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)BotanyPotsMod.id("crop")).cast();
    public static final SidedReloadableCache<Map<ResourceLocation, RecipeHolder<Crop>>> RECIPES = SidedReloadableCache.recipes(TYPE);
    public static final SidedReloadableCache<RecipeCache<Crop>> CACHE = RecipeCache.of(TYPE);

    public abstract void onHarvest(BotanyPotContext var1, Level var2, Consumer<ItemStack> var3);

    public abstract List<Display> getDisplayState(BotanyPotContext var1, Level var2);

    public abstract int getRequiredGrowthTicks(BotanyPotContext var1, Level var2);

    public abstract boolean isGrowthSustained(BotanyPotContext var1, Level var2);

    public int getLightLevelEmitted(BotanyPotContext context, Level level) {
        return 0;
    }

    public float getBaseYield(BotanyPotContext context, Level level) {
        return 1.0f;
    }

    public float getYieldScale(BotanyPotContext context, Level level) {
        return 1.0f;
    }

    public void onTick(BotanyPotContext context, Level level) {
    }

    public void onGrowthTick(BotanyPotContext context, Level level) {
    }

    public boolean canHarvest(BotanyPotContext context, Level level) {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE.get();
    }

    @Nullable
    public static RecipeHolder<Crop> getCrop(Level level, BotanyPotContext context, ItemStack stack) {
        RecipeCache cache = (RecipeCache)CACHE.apply(level);
        return cache != null ? cache.lookup(stack, context, level) : null;
    }
}

