/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class EntityDrops
implements ItemDropProvider {
    public static final Supplier<ItemDropProviderType<?>> TYPE = ItemDropProviderType.getLazy(BotanyPotsMod.id("entity"));
    public static final MapCodec<EntityDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("entity").forGetter(EntityDrops::getEntityData), (App)DamageType.CODEC.optionalFieldOf("damage_source").forGetter(EntityDrops::getDamageType)).apply((Applicative)instance, EntityDrops::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityDrops> STREAM = StreamCodec.of((buf, value) -> {
        ByteBufCodecs.COMPOUND_TAG.encode(buf, (Object)value.entityData);
        if (value.damageType.isPresent()) {
            buf.writeBoolean(true);
            DamageType.STREAM_CODEC.encode(buf, value.damageType.get());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeResourceKey((ResourceKey)value.lootTableId.get());
        ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode(buf, value.getDisplayItems());
    }, buf -> {
        CompoundTag entityData = (CompoundTag)ByteBufCodecs.COMPOUND_TAG.decode(buf);
        boolean hasDamageType = buf.readBoolean();
        Optional<Holder<DamageType>> damageType = hasDamageType ? Optional.of((Holder)DamageType.STREAM_CODEC.decode(buf)) : Optional.empty();
        ResourceKey tableId = buf.readResourceKey(Registries.LOOT_TABLE);
        List displayItems = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode(buf);
        return new EntityDrops(entityData, damageType, (ResourceKey<LootTable>)tableId, displayItems);
    });
    private final CompoundTag entityData;
    private final Optional<Holder<DamageType>> damageType;
    private final ReloadableCache<LivingEntity> entity;
    private final CachedSupplier<ResourceKey<LootTable>> lootTableId;
    private final CachedSupplier<List<ItemStack>> displayItems;

    public EntityDrops(CompoundTag entityData, Optional<Holder<DamageType>> damageType) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living((CompoundTag)entityData);
        this.lootTableId = CachedSupplier.cache(() -> {
            ResourceLocation entityId;
            if (entityData.contains("DeathLootTable", 8)) {
                return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)entityData.getString("DeathLootTable")));
            }
            if (entityData.contains("id", 8) && (entityId = ResourceLocation.tryParse((String)entityData.getString("id"))) != null && BuiltInRegistries.ENTITY_TYPE.containsKey(entityId)) {
                return ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId)).getDefaultLootTable();
            }
            return BuiltInLootTables.EMPTY;
        });
        this.displayItems = CachedSupplier.cache(() -> {
            LootTable table = (LootTable)Objects.requireNonNull((RegistryAccess)BotanyPotsMod.REGISTRY_ACCESS.get()).registryOrThrow(Registries.LOOT_TABLE).get((ResourceKey)this.lootTableId.get());
            return table != null ? LootPoolEntryDescriptions.getUniqueItems((RegistryAccess)Objects.requireNonNull((RegistryAccess)BotanyPotsMod.REGISTRY_ACCESS.get()), (LootTable)table) : List.of();
        });
    }

    public EntityDrops(CompoundTag entityData, Optional<Holder<DamageType>> damageType, ResourceKey<LootTable> tableId, List<ItemStack> displayItems) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living((CompoundTag)entityData);
        this.lootTableId = CachedSupplier.singleton(tableId);
        this.displayItems = CachedSupplier.singleton(displayItems);
    }

    public CompoundTag getEntityData() {
        return this.entityData;
    }

    public Optional<Holder<DamageType>> getDamageType() {
        return this.damageType;
    }

    @Override
    public void apply(BotanyPotContext context, Level level, Consumer<ItemStack> drops) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.entity.ifPresent(level, living -> {
                ResourceKey resourcekey = living.getLootTable();
                LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(resourcekey);
                LootParams.Builder paramBuilder = new LootParams.Builder(serverLevel);
                paramBuilder.withParameter(LootContextParams.THIS_ENTITY, living);
                paramBuilder.withParameter(LootContextParams.ORIGIN, (Object)living.position());
                paramBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.damageType.map(DamageSource::new).orElseGet(() -> serverLevel.damageSources().generic()));
                loottable.getRandomItems(paramBuilder.create(LootContextParamSets.ENTITY), living.getLootTableSeed(), drops);
            });
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return TYPE.get();
    }

    @Override
    public List<ItemStack> getDisplayItems() {
        return (List)this.displayItems.get();
    }
}

