/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class ConveyorBlinkingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = Shapes.box((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 3, 3);
    private boolean whitelist = false;
    private int verticalDisplacement = 0;
    private int horizontalDisplacement = 1;

    public ConveyorBlinkingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        Direction direction = (Direction)this.getContainer().getBlockWorld().getBlockState(this.getContainer().getBlockPosition()).getValue((Property)ConveyorBlock.FACING);
        Vec3 vec3d = new Vec3((double)(this.horizontalDisplacement * direction.getNormal().getX()), (double)this.verticalDisplacement, (double)(this.horizontalDisplacement * direction.getNormal().getZ()));
        BlockPos pos = this.getPos().offset((int)vec3d.x, (int)vec3d.y, (int)vec3d.z);
        entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5);
        this.getWorld().playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.AMBIENT, 0.5f, 1.0f);
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider) == null ? new CompoundTag() : super.serializeNBT(provider);
        compound.put("Filter", (Tag)this.filter.serializeNBT(provider));
        compound.putBoolean("Whitelist", this.whitelist);
        compound.putDouble("VerticalDisplacement", (double)this.verticalDisplacement);
        compound.putDouble("HorizontalDisplacement", (double)this.horizontalDisplacement);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(provider, nbt.getCompound("Filter"));
        }
        this.whitelist = nbt.getBoolean("Whitelist");
        this.horizontalDisplacement = nbt.getInt("HorizontalDisplacement");
        this.verticalDisplacement = nbt.getInt("VerticalDisplacement");
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 10) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 11 && this.horizontalDisplacement < 8) {
            ++this.horizontalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 12 && this.horizontalDisplacement > 1) {
            --this.horizontalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 13 && this.verticalDisplacement < 8) {
            ++this.verticalDisplacement;
            this.getContainer().requestSync();
        }
        if (buttonId == 14 && this.verticalDisplacement > -8) {
            --this.verticalDisplacement;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorBlinkingUpgrade.this.filter;
            }
        });
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(10, 80, 19, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorBlinkingUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TextureGuiComponent(80, 40, 16, 16, res, 2, 234, "distance_horizontal"));
        componentList.add(new TextureGuiComponent(80, 56, 16, 16, res, 21, 234, "distance_vertical"));
        componentList.add(new TextGuiComponent(104, 44){

            @Override
            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + " " + ConveyorBlinkingUpgrade.this.horizontalDisplacement;
            }
        });
        componentList.add(new TextGuiComponent(104, 61){

            @Override
            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + (ConveyorBlinkingUpgrade.this.verticalDisplacement >= 0 ? " " : "") + ConveyorBlinkingUpgrade.this.verticalDisplacement;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 11, 130, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 12, 146, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 13, 130, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(this, 14, 146, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("blinking");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorBlinkingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/conveyor_blinking_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(Level world, BlockPos pos, Player player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/conveyor_upgrade_blinking");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"conveyor_blinking_upgrade");
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).pattern("IPI").pattern("IDI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.CHORUS_FRUIT).define(Character.valueOf('D'), (ItemLike)Blocks.PISTON).define(Character.valueOf('C'), (ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()).save(consumer);
        }
    }
}

