/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ConveyorExtractionUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTHBB = Shapes.box((double)0.25, (double)0.1875, (double)-0.125, (double)0.75, (double)0.6875, (double)0.1875);
    public static VoxelShape SOUTHBB = Shapes.box((double)0.25, (double)0.1875, (double)0.8125, (double)0.75, (double)0.6875, (double)1.125);
    public static VoxelShape EASTBB = Shapes.box((double)0.8125, (double)0.1875, (double)0.25, (double)1.125, (double)0.6875, (double)0.75);
    public static VoxelShape WESTBB = Shapes.box((double)-0.125, (double)0.1875, (double)0.25, (double)0.1875, (double)0.6875, (double)0.75);
    private boolean fast = false;
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private List<ItemEntity> items = new ArrayList<ItemEntity>();

    public ConveyorExtractionUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("fast", this.fast);
        compound.put("Filter", (Tag)this.filter.serializeNBT(provider));
        compound.putBoolean("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.fast = nbt.getBoolean("fast");
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(provider, nbt.getCompound("Filter"));
        }
        this.whitelist = nbt.getBoolean("Whitelist");
    }

    @Override
    public boolean onUpgradeActivated(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (held.getItem() == Items.GLOWSTONE_DUST && !this.fast) {
            this.fast = true;
            held.shrink(1);
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        if (!this.fast) {
            return super.getDrops();
        }
        return Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((ItemLike)this.getFactory().getUpgradeItem(), 1), new ItemStack((ItemLike)Items.GLOWSTONE_DUST)});
    }

    @Override
    public void update() {
        if (this.getWorld().isClientSide) {
            return;
        }
        this.items.removeIf(ItemEntity2 -> ItemEntity2.getItem().isEmpty() || !ItemEntity2.isAlive());
        if (this.items.size() >= 20) {
            return;
        }
        if (this.getWorld().getGameTime() % (long)(this.fast ? 10 : 20) == 0L) {
            this.getHandlerCapability(Capabilities.ItemHandler.BLOCK, Capabilities.ItemHandler.ENTITY_AUTOMATION).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.extractItem(i, 4, true);
                    if (stack.isEmpty() || this.whitelist != this.filter.matches(stack)) continue;
                    ItemEntity item = new ItemEntity(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.2, (double)this.getPos().getZ() + 0.5, stack);
                    item.setDeltaMovement(0.0, -1.0, 0.0);
                    item.setPickUpDelay(40);
                    item.setItem(itemHandler.extractItem(i, 4, false));
                    if (!this.getWorld().addFreshEntity((Entity)item)) break;
                    this.items.add(item);
                    break;
                }
            });
        }
        if (this.getContainer() instanceof ConveyorTile) {
            FluidTank tank = ((ConveyorTile)this.getContainer()).getTank();
            this.getHandlerCapability(Capabilities.FluidHandler.BLOCK, Capabilities.FluidHandler.ENTITY).ifPresent(arg_0 -> this.lambda$update$2((IFluidTank)tank, arg_0));
        }
    }

    private <T> Optional<T> getHandlerCapability(BlockCapability<T, Direction> capability, EntityCapability<T, Direction> entityCapability) {
        BlockPos offsetPos = this.getPos().relative(this.getSide());
        Object cap = this.getWorld().getCapability(capability, offsetPos, (Object)this.getSide().getOpposite());
        if (cap != null) {
            return Optional.of(cap);
        }
        Iterator iterator = this.getWorld().getEntitiesOfClass(Entity.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).move(offsetPos)).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Object entityCap = entity.getCapability(entityCapability, (entity = (Entity)iterator.next()) instanceof ServerPlayer ? null : this.getSide().getOpposite());
            if (entityCap == null) continue;
            return Optional.of(entityCap);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.parseOptional((HolderLookup.Provider)this.getWorld().registryAccess(), (CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorExtractionUpgrade.this.filter;
            }
        });
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorExtractionUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    private /* synthetic */ void lambda$update$2(IFluidTank tank, IFluidHandler fluidHandler) {
        FluidStack drain;
        if (!fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE).isEmpty() && this.whitelist == this.filter.matches(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE)) && (drain = fluidHandler.drain(tank.fill(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drain.getAmount() > 0) {
            this.getContainer().requestFluidSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("extraction");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorExtractionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/conveyor_upgrade_extractor_" + upgradeSide.getSerializedName().toLowerCase()));
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"conveyor_extraction_upgrade");
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).pattern("IPI").pattern("IDI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('D'), (ItemLike)Blocks.DISPENSER).define(Character.valueOf('C'), (ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()).save(consumer);
        }
    }
}

