/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin;

import com.buuz135.industrial.block.generator.tile.BioReactorTile;
import com.buuz135.industrial.block.resourceproduction.tile.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.plugin.jei.StoneWorkWrapper;
import com.buuz135.industrial.plugin.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class RecipeViewerHelper {
    public static List<BioReactorRecipeCategory.ReactorRecipeWrapper> generateBioreactorRecipes() {
        ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper> recipes = new ArrayList<BioReactorRecipeCategory.ReactorRecipeWrapper>();
        for (TagKey<Item> itemTag : BioReactorTile.VALID) {
            recipes.add(new BioReactorRecipeCategory.ReactorRecipeWrapper(itemTag, new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get(), 80)));
        }
        return recipes;
    }

    public static ItemStack getStoneWorkOutputFrom(ItemStack stack, MaterialStoneWorkFactoryTile.StoneWorkAction mode) {
        return mode.getWork().apply((Level)Minecraft.getInstance().level, stack.copyWithCount(9));
    }

    public static ItemStack getStoneWorkOutputFrom(ItemStack stack, List<MaterialStoneWorkFactoryTile.StoneWorkAction> modes) {
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : modes) {
            if (!(stack = RecipeViewerHelper.getStoneWorkOutputFrom(stack.copy(), mode)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static List<StoneWorkWrapper> findAllStoneWorkOutputs(ItemStack parent, List<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModes) {
        ArrayList<StoneWorkWrapper> wrappers = new ArrayList<StoneWorkWrapper>();
        if (usedModes.size() >= 4) {
            return wrappers;
        }
        for (MaterialStoneWorkFactoryTile.StoneWorkAction mode : MaterialStoneWorkFactoryTile.ACTION_RECIPES) {
            if (mode.getAction().equals("none")) continue;
            ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> usedModesInternal = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModes);
            usedModesInternal.add(mode);
            ItemStack output = RecipeViewerHelper.getStoneWorkOutputFrom(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal));
            if (output.isEmpty()) continue;
            wrappers.add(new StoneWorkWrapper(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal), output.copy()));
            wrappers.addAll(RecipeViewerHelper.findAllStoneWorkOutputs(parent, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(usedModesInternal)));
        }
        return wrappers;
    }

    public static List<StoneWorkWrapper> getStoneWork() {
        ArrayList<StoneWorkWrapper> perfectStoneWorkWrappers = new ArrayList<StoneWorkWrapper>();
        for (StoneWorkGenerateRecipe generatorRecipe : RecipeUtil.getRecipes((Level)Minecraft.getInstance().level, (RecipeType)((RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get()))) {
            List<StoneWorkWrapper> wrappers = RecipeViewerHelper.findAllStoneWorkOutputs(generatorRecipe.output, new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>());
            for (StoneWorkWrapper workWrapper : new ArrayList<StoneWorkWrapper>(wrappers)) {
                if (!perfectStoneWorkWrappers.stream().noneMatch(stoneWorkWrapper -> ItemStack.isSameItem((ItemStack)workWrapper.output(), (ItemStack)stoneWorkWrapper.output()))) continue;
                boolean isSomoneShorter = false;
                for (StoneWorkWrapper workWrapperCompare : new ArrayList<StoneWorkWrapper>(wrappers)) {
                    if (!ItemStack.isSameItem((ItemStack)workWrapper.output(), (ItemStack)workWrapperCompare.output())) continue;
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperCompareModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapperCompare.modes());
                    workWrapperCompareModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction> workWrapperModes = new ArrayList<MaterialStoneWorkFactoryTile.StoneWorkAction>(workWrapper.modes());
                    workWrapperModes.removeIf(mode -> mode.getAction().equalsIgnoreCase("none"));
                    if (workWrapperModes.size() <= workWrapperCompareModes.size()) continue;
                    isSomoneShorter = true;
                    break;
                }
                if (isSomoneShorter) continue;
                perfectStoneWorkWrappers.add(workWrapper);
            }
        }
        return perfectStoneWorkWrappers;
    }
}

