/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.emi;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import com.buuz135.industrial.block.generator.MycelialGeneratorBlock;
import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.fluid.OreTitaniumFluidType;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.plugin.RecipeViewerHelper;
import com.buuz135.industrial.plugin.emi.category.BioreactorEmiCategory;
import com.buuz135.industrial.plugin.emi.category.DissolutionChamberEmiCategory;
import com.buuz135.industrial.plugin.emi.category.FermentationStationEmiCategory;
import com.buuz135.industrial.plugin.emi.category.FluidExtractorEmiCategory;
import com.buuz135.industrial.plugin.emi.category.FluidSieveEmiCategory;
import com.buuz135.industrial.plugin.emi.category.LaserDrillFluidEmiCategory;
import com.buuz135.industrial.plugin.emi.category.LaserDrillOreEmiCategory;
import com.buuz135.industrial.plugin.emi.category.MycelialGeneratorEmiCategory;
import com.buuz135.industrial.plugin.emi.category.OreWasherEmiCategory;
import com.buuz135.industrial.plugin.emi.category.StoneWorkEmiCategory;
import com.buuz135.industrial.plugin.emi.category.StoneWorkGeneratorEmiCategory;
import com.buuz135.industrial.plugin.emi.recipe.BioreactorEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.DissChamberEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.FermentationStationEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.FluidExtractorEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.FluidSieveEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.LaserDrillFluidEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.LaserDrillOreEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.MycelialGeneratorEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.OreWasherEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.StoneWorkEmiRecipe;
import com.buuz135.industrial.plugin.emi.recipe.StoneWorkGeneratorEmiRecipe;
import com.buuz135.industrial.plugin.jei.StoneWorkWrapper;
import com.buuz135.industrial.plugin.jei.category.BioReactorRecipeCategory;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.util.TagUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

@EmiEntrypoint
public class IFEmiPlugin
implements EmiPlugin {
    public static final DissolutionChamberEmiCategory DISSOLUTION_CHAMBER_EMI_CATEGORY = new DissolutionChamberEmiCategory();
    public static final BioreactorEmiCategory BIOREACTOR_EMI_CATEGORY = new BioreactorEmiCategory();
    public static final FermentationStationEmiCategory FERMENTATION_STATION_EMI_CATEGORY = new FermentationStationEmiCategory();
    public static final FluidExtractorEmiCategory FLUID_EXTRACTOR_EMI_CATEGORY = new FluidExtractorEmiCategory();
    public static final FluidSieveEmiCategory FLUID_SIEVE_EMI_CATEGORY = new FluidSieveEmiCategory();
    public static final LaserDrillOreEmiCategory LASER_DRILL_ORE_EMI_CATEGORY = new LaserDrillOreEmiCategory();
    public static final LaserDrillFluidEmiCategory LASER_DRILL_FLUID_EMI_CATEGORY = new LaserDrillFluidEmiCategory();
    public static final OreWasherEmiCategory ORE_WASHER_EMI_CATEGORY = new OreWasherEmiCategory();
    public static final StoneWorkEmiCategory STONE_WORK_EMI_CATEGORY = new StoneWorkEmiCategory();
    public static final StoneWorkGeneratorEmiCategory STONE_WORK_GENERATOR = new StoneWorkGeneratorEmiCategory();

    public void initialize(EmiInitRegistry registry) {
    }

    public void register(EmiRegistry registry) {
        RecipeManager manager = registry.getRecipeManager();
        registry.addCategory((EmiRecipeCategory)DISSOLUTION_CHAMBER_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)DISSOLUTION_CHAMBER_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleCore.DISSOLUTION_CHAMBER.getBlock()})));
        for (RecipeHolder recipe2 : manager.getAllRecipesFor((RecipeType)ModuleCore.DISSOLUTION_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new DissChamberEmiRecipe((RecipeHolder<DissolutionChamberRecipe>)recipe2));
        }
        registry.addCategory((EmiRecipeCategory)BIOREACTOR_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)BIOREACTOR_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleGenerator.BIOREACTOR.getBlock()})));
        for (BioReactorRecipeCategory.ReactorRecipeWrapper generateBioreactorRecipe : RecipeViewerHelper.generateBioreactorRecipes()) {
            registry.addRecipe((EmiRecipe)new BioreactorEmiRecipe(generateBioreactorRecipe.getStack(), generateBioreactorRecipe.getFluid()));
        }
        ArrayList washer = new ArrayList();
        ArrayList fluidEntryFermenters = new ArrayList();
        ArrayList fluidSieve = new ArrayList();
        BuiltInRegistries.ITEM.getTagNames().map(itemTagKey -> itemTagKey.location()).filter(resourceLocation -> resourceLocation.toString().startsWith("c:raw_materials/") && OreTitaniumFluidType.isValid(resourceLocation)).forEach(resourceLocation -> {
            TagKey tag = TagUtil.getItemTag((ResourceLocation)resourceLocation);
            TagKey dust = TagUtil.getItemTag((ResourceLocation)ResourceLocation.parse((String)resourceLocation.toString().replace("c:raw_materials/", "c:dusts/")));
            washer.add(new OreFluidEntryRaw((TagKey<Item>)tag, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 100), OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation)));
            fluidEntryFermenters.add(new OreFluidEntryFermenter(OreTitaniumFluidType.getFluidWithTag(ModuleCore.RAW_ORE_MEAT, 100, resourceLocation), OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 200, resourceLocation)));
            fluidSieve.add(new OreFluidEntrySieve(OreTitaniumFluidType.getFluidWithTag(ModuleCore.FERMENTED_ORE_MEAT, 100, resourceLocation), TagUtil.getItemWithPreference((TagKey)dust), (TagKey<Item>)ItemTags.SAND));
        });
        registry.addCategory((EmiRecipeCategory)ORE_WASHER_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)ORE_WASHER_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.WASHING_FACTORY.getBlock()})));
        washer.forEach(wash -> registry.addRecipe((EmiRecipe)new OreWasherEmiRecipe((OreFluidEntryRaw)wash)));
        registry.addCategory((EmiRecipeCategory)FERMENTATION_STATION_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)FERMENTATION_STATION_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.FERMENTATION_STATION.getBlock()})));
        fluidEntryFermenters.forEach(oreFluidEntryFermenter -> registry.addRecipe((EmiRecipe)new FermentationStationEmiRecipe((OreFluidEntryFermenter)oreFluidEntryFermenter)));
        registry.addCategory((EmiRecipeCategory)FLUID_SIEVE_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)FLUID_SIEVE_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.FLUID_SIEVING_MACHINE.getBlock()})));
        fluidSieve.forEach(fluidSieves -> registry.addRecipe((EmiRecipe)new FluidSieveEmiRecipe((OreFluidEntrySieve)fluidSieves)));
        registry.addCategory((EmiRecipeCategory)FLUID_EXTRACTOR_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)FLUID_EXTRACTOR_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleCore.FLUID_EXTRACTOR.getBlock()})));
        for (RecipeHolder recipe3 : manager.getAllRecipesFor((RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new FluidExtractorEmiRecipe((RecipeHolder<FluidExtractorRecipe>)recipe3));
        }
        registry.addCategory((EmiRecipeCategory)LASER_DRILL_ORE_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)LASER_DRILL_ORE_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.ORE_LASER_BASE.getBlock()})));
        for (RecipeHolder recipe3 : manager.getAllRecipesFor((RecipeType)ModuleCore.LASER_DRILL_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new LaserDrillOreEmiRecipe((RecipeHolder<LaserDrillOreRecipe>)recipe3));
        }
        registry.addCategory((EmiRecipeCategory)LASER_DRILL_FLUID_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)LASER_DRILL_FLUID_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.FLUID_LASER_BASE.getBlock()})));
        for (RecipeHolder recipe3 : manager.getAllRecipesFor((RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new LaserDrillFluidEmiRecipe((RecipeHolder<LaserDrillFluidRecipe>)recipe3));
        }
        registry.addCategory((EmiRecipeCategory)STONE_WORK_EMI_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)STONE_WORK_EMI_CATEGORY, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY.getBlock()})));
        RecipeViewerHelper.getStoneWork().forEach(stoneWorkWrapper -> registry.addRecipe((EmiRecipe)new StoneWorkEmiRecipe((StoneWorkWrapper)stoneWorkWrapper)));
        registry.addCategory((EmiRecipeCategory)STONE_WORK_GENERATOR);
        registry.addWorkstation((EmiRecipeCategory)STONE_WORK_GENERATOR, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY.getBlock()})));
        for (RecipeHolder recipe3 : manager.getAllRecipesFor((RecipeType)ModuleCore.STONEWORK_GENERATE_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new StoneWorkGeneratorEmiRecipe((RecipeHolder<StoneWorkGenerateRecipe>)recipe3));
        }
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModuleResourceProduction.RESOURCEFUL_FURNACE.getBlock()})));
        for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
            Item display = type.getDisplay();
            for (BlockWithTile mycelialGenerator : ModuleGenerator.MYCELIAL_GENERATORS) {
                if (!((MycelialGeneratorBlock)mycelialGenerator.getBlock()).getType().equals(type)) continue;
                display = mycelialGenerator.getBlock();
            }
            MycelialGeneratorEmiCategory category = new MycelialGeneratorEmiCategory(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("mycellial_" + type.getName())), display.asItem(), type);
            registry.addCategory((EmiRecipeCategory)category);
            registry.addWorkstation((EmiRecipeCategory)category, (EmiIngredient)EmiStack.of((ItemLike)display));
            List<MycelialGeneratorRecipe> recipes = type.getRecipes(IFAttachments.registryAccess()).stream().sorted(Comparator.comparingInt(value -> ((MycelialGeneratorRecipe)value).getTicks() * ((MycelialGeneratorRecipe)value).getPowerTick()).reversed()).collect(Collectors.toList());
            recipes.forEach(recipe -> registry.addRecipe((EmiRecipe)new MycelialGeneratorEmiRecipe(type, (MycelialGeneratorRecipe)recipe, category)));
        }
    }
}

