/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public abstract class IndustrialForegoingISTER
extends BlockEntityWithoutLevelRenderer {
    public IndustrialForegoingISTER() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    private static boolean isLeftHand(ItemDisplayContext type) {
        return type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    protected EntityModelSet getEntityModels() {
        return Minecraft.getInstance().getEntityModels();
    }

    protected BlockEntityRenderDispatcher getBlockEntityRenderDispatcher() {
        return Minecraft.getInstance().getBlockEntityRenderDispatcher();
    }

    protected Camera getCamera() {
        return this.getBlockEntityRenderDispatcher().camera;
    }

    public abstract void onResourceManagerReload(@NotNull ResourceManager var1);

    public abstract void renderByItem(HolderLookup.Provider var1, @NotNull ItemStack var2, @NotNull ItemDisplayContext var3, @NotNull PoseStack var4, @NotNull MultiBufferSource var5, int var6, int var7);

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderByItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    protected void renderBlockItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, ModelData modelData) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        boolean fabulous = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() ? !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        matrix.popPose();
        matrix.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        BlockState defaultState = block.defaultBlockState();
        BakedModel mainModel = minecraft.getModelManager().getBlockModelShaper().getBlockModel(defaultState);
        mainModel = mainModel.applyTransform(displayContext, matrix, IndustrialForegoingISTER.isLeftHand(displayContext));
        matrix.translate(-0.5, -0.5, -0.5);
        long seed = 42L;
        RandomSource random = RandomSource.create();
        boolean glint = stack.hasFoil();
        for (BakedModel model : mainModel.getRenderPasses(stack, fabulous)) {
            for (RenderType renderType : model.getRenderTypes(stack, fabulous)) {
                VertexConsumer consumer = null;
                consumer = fabulous ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)renderType, (boolean)true, (boolean)glint) : ItemRenderer.getFoilBuffer((MultiBufferSource)renderer, (RenderType)renderType, (boolean)true, (boolean)glint);
                for (Direction direction : Direction.values()) {
                    random.setSeed(seed);
                    itemRenderer.renderQuadList(matrix, consumer, model.getQuads(defaultState, direction, random, modelData, null), stack, light, overlayLight);
                }
                random.setSeed(seed);
                itemRenderer.renderQuadList(matrix, consumer, model.getQuads(defaultState, null, random, modelData, null), stack, light, overlayLight);
            }
        }
    }

    public void renderItem(ItemStack itemStack, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel p_model) {
        if (!itemStack.isEmpty()) {
            BlockItem blockitem;
            Block block;
            Item item;
            poseStack.pushPose();
            boolean flag = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
            p_model = ClientHooks.handleCameraTransforms((PoseStack)poseStack, (BakedModel)p_model, (ItemDisplayContext)displayContext, (boolean)leftHand);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            if (!flag) {
                // empty if block
            }
            boolean flag1 = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = itemStack.getItem()) instanceof BlockItem ? !((block = (blockitem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
            for (BakedModel model : p_model.getRenderPasses(itemStack, flag1)) {
                for (RenderType rendertype : model.getRenderTypes(itemStack, flag1)) {
                    VertexConsumer vertexconsumer;
                    if (itemStack.hasFoil()) {
                        PoseStack.Pose posestack$pose = poseStack.last().copy();
                        if (displayContext == ItemDisplayContext.GUI) {
                            MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.5f);
                        } else if (displayContext.firstPerson()) {
                            MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.75f);
                        }
                        vertexconsumer = ItemRenderer.getCompassFoilBuffer((MultiBufferSource)bufferSource, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                    } else {
                        vertexconsumer = flag1 ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.hasFoil());
                    }
                    Minecraft.getInstance().getItemRenderer().renderModelLists(model, itemStack, combinedLight, combinedOverlay, poseStack, vertexconsumer);
                }
            }
            poseStack.popPose();
        }
    }
}

