/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class ChorusCache {
    private List<BlockPos> chorus;
    private Level world;

    public ChorusCache(Level world, BlockPos current) {
        this.world = world;
        this.chorus = new ArrayList<BlockPos>();
        Stack<BlockPos> chorus = new Stack<BlockPos>();
        chorus.push(current);
        while (!chorus.isEmpty()) {
            BlockPos checking = (BlockPos)chorus.pop();
            if (!BlockUtils.isChorus(world, checking)) continue;
            Iterable area = BlockPos.betweenClosed((BlockPos)checking.relative(Direction.DOWN).relative(Direction.SOUTH).relative(Direction.WEST), (BlockPos)checking.relative(Direction.UP).relative(Direction.NORTH).relative(Direction.EAST));
            for (BlockPos blockPos : area) {
                if (!BlockUtils.isChorus(world, blockPos) || this.chorus.contains(blockPos) || !(blockPos.distSqr((Vec3i)current) <= 100.0)) continue;
                chorus.push(blockPos.immutable());
                this.chorus.add(blockPos.immutable());
            }
        }
    }

    public boolean isFullyGrown() {
        return this.chorus.stream().map(blockpos -> this.world.getBlockState(blockpos)).allMatch(blockState -> blockState.getBlock().equals(Blocks.CHORUS_PLANT) || blockState.getBlock().equals(Blocks.CHORUS_FLOWER) && (Integer)blockState.getValue((Property)ChorusFlowerBlock.AGE) == 5);
    }

    public List<ItemStack> chop() {
        NonNullList stacks = NonNullList.create();
        int maxY = this.getTopRowY();
        this.chorus.stream().filter(pos -> pos.getY() == maxY).forEach(pos -> this.chop((NonNullList<ItemStack>)stacks, (BlockPos)pos));
        this.chorus.removeIf(pos -> pos.getY() == maxY);
        return stacks;
    }

    public void chop(NonNullList<ItemStack> stacks, BlockPos p) {
        if (BlockUtils.isChorus(this.world, p)) {
            if (this.world.getBlockState(p).getBlock().equals(Blocks.CHORUS_FLOWER)) {
                stacks.add((Object)new ItemStack((ItemLike)Blocks.CHORUS_FLOWER));
            } else {
                stacks.addAll(BlockUtils.getBlockDrops(this.world, p));
            }
            this.world.setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
        }
    }

    public int getTopRowY() {
        int i = 0;
        for (BlockPos blockPos : this.chorus) {
            if (blockPos.getY() <= i) continue;
            i = blockPos.getY();
        }
        return i;
    }

    public List<BlockPos> getChorus() {
        return this.chorus;
    }
}

