/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.tags;

import com.github.jarva.arsadditions.ArsAdditions;
import com.hollingsworth.arsnouveau.common.datagen.StructureTagProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class StructureTagDatagen
extends TagsProvider<Structure> {
    public static TagKey<Structure> ON_EXPLORER_WARP_SCROLL = StructureTagDatagen.create("on_explorer_warp_scroll");
    public static TagKey<Structure> RUINED_PORTALS = StructureTagDatagen.create("ruined_portals");
    public static TagKey<Structure> MONUMENT = StructureTagDatagen.create("monument");
    public static TagKey<Structure> DESERT_TEMPLE = StructureTagDatagen.create("desert_temple");
    public static TagKey<Structure> JUNGLE_TEMPLE = StructureTagDatagen.create("jungle_temple");
    public static TagKey<Structure> STRONGHOLD = StructureTagDatagen.create("stronghold");
    public static TagKey<Structure> NETHER_FORTRESS = StructureTagDatagen.create("nether_fortress");
    public static TagKey<Structure> ANCIENT_CITY = StructureTagDatagen.create("ancient_city");
    public static TagKey<Structure> PILLAGER_OUTPOST = StructureTagDatagen.create("pillager_outpost");
    public static TagKey<Structure> IGLOO = StructureTagDatagen.create("igloo");
    public static TagKey<Structure> TRAIL_RUINS = StructureTagDatagen.create("trail_ruins");
    public static TagKey<Structure> WITCH_HUT = StructureTagDatagen.create("witch_hut");
    public static TagKey<Structure> BASTION = StructureTagDatagen.create("bastion");
    public static TagKey<Structure> END_CITY = StructureTagDatagen.create("end_city");
    public static TagKey<Structure> TRIAL_CHAMBERS = StructureTagDatagen.create("trial_chambers");
    public static TagKey<Structure> WOODLAND_MANSION = StructureTagDatagen.create("woodland_mansion");

    public StructureTagDatagen(PackOutput arg, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper helper) {
        super(arg, Registries.STRUCTURE, future, "ars_additions", helper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.tag(MONUMENT).addOptional(BuiltinStructures.OCEAN_MONUMENT.location()).addOptionalTag(StructureTagDatagen.parse("betteroceanmonuments:better_ocean_monuments"));
        this.tag(DESERT_TEMPLE).addOptional(BuiltinStructures.DESERT_PYRAMID.location()).addOptionalTag(StructureTagDatagen.parse("betterdeserttemples:better_desert_temples"));
        this.tag(JUNGLE_TEMPLE).addOptional(BuiltinStructures.JUNGLE_TEMPLE.location()).addOptionalTag(StructureTagDatagen.parse("betterjungletemples:better_jungle_temples"));
        this.tag(STRONGHOLD).addOptional(BuiltinStructures.STRONGHOLD.location()).addOptionalTag(StructureTagDatagen.parse("betterstrongholds:better_strongholds"));
        this.tag(NETHER_FORTRESS).addOptional(BuiltinStructures.FORTRESS.location()).addOptionalTag(StructureTagDatagen.parse("betterfortresses:better_fortresses"));
        this.tag(ANCIENT_CITY).addOptional(BuiltinStructures.ANCIENT_CITY.location());
        this.tag(PILLAGER_OUTPOST).addOptional(BuiltinStructures.PILLAGER_OUTPOST.location()).addOptionalTag(StructureTagDatagen.parse("minecraft:pillager_outpost"));
        this.tag(IGLOO).addOptional(BuiltinStructures.IGLOO.location());
        this.tag(TRAIL_RUINS).addOptional(BuiltinStructures.TRAIL_RUINS.location());
        this.tag(WITCH_HUT).addOptional(BuiltinStructures.SWAMP_HUT.location()).addOptional(StructureTagDatagen.parse("betterwitchhuts:witch_hut"));
        this.tag(BASTION).addOptional(BuiltinStructures.BASTION_REMNANT.location());
        this.tag(END_CITY).addOptional(BuiltinStructures.END_CITY.location());
        this.tag(TRIAL_CHAMBERS).addOptional(BuiltinStructures.TRIAL_CHAMBERS.location());
        this.tag(WOODLAND_MANSION).addOptional(BuiltinStructures.WOODLAND_MANSION.location());
        this.tag(ON_EXPLORER_WARP_SCROLL).addTag(MONUMENT).addTag(DESERT_TEMPLE).addTag(JUNGLE_TEMPLE).addTag(STRONGHOLD).addTag(NETHER_FORTRESS).addTag(ANCIENT_CITY).addTag(PILLAGER_OUTPOST).addTag(IGLOO).addTag(WITCH_HUT).addTag(StructureTagProvider.WILDEN_DEN).add(StructureTagDatagen.structure("nexus_tower")).add(StructureTagDatagen.structure("arcane_library"));
        this.tag(RUINED_PORTALS).add(StructureTagDatagen.structure("ruined_portal")).add(StructureTagDatagen.structure("ruined_portal_large"));
    }

    public static TagKey<Structure> create(String name) {
        return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix(name));
    }

    public static ResourceKey<Structure> structure(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix(name));
    }

    public static ResourceLocation parse(String name) {
        return ResourceLocation.parse((String)name);
    }
}

