/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config;

import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface PCCommonConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbpc-common");
    public static final BooleanValue BREAK_LIGHT_SOURCES_NEAR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("break_light_sources_near_spawners", false).comment(new String[]{"When enabled, light sources near spawners will be broken to allow for mob spawning."});
    public static final BooleanValue IGNORE_LIGHT_LEVEL_FOR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("ignore_light_level_for_spawners", false).comment(new String[]{"When enabled, the light level around spawners will be ignored for mob spawning."});
    public static final BooleanValue REMOVE_CONCENTRIC_RING_PLACEMENT_BIAS = (BooleanValue)CONFIG.addBoolean("remove_concentric_ring_placement_bias", false).comment(new String[]{"When enabled, the random bias applied to concentric ring distances is removed"});
    public static final SparseStructuresValue SPARSE_STRUCTURES = (SparseStructuresValue)CONFIG.add((BaseValue)new SparseStructuresValue(CONFIG, "sparse_structures", SparseStructuresConfig.DEFAULT));
    public static final SNBTConfig SHADERS_NOTICE = CONFIG.addGroup("shaders_notice");
    public static final StringValue SHADER_PACK_TO_USE = (StringValue)SHADERS_NOTICE.addString("shader_pack_to_use", "").comment(new String[]{"The shader pack to use when enabling shaders. Leave empty to use the default shader pack / first available shader pack in the list"});
    public static final BooleanValue SHOW_ON_START = (BooleanValue)SHADERS_NOTICE.addBoolean("show_on_start", false).comment(new String[]{"When enabled, the shaders notice will be shown on world start if shaders are included in the pack."});

    public static void load() {
        ConfigManager.getInstance().registerServerConfig(CONFIG, "ftbpc.common", true);
    }

    public static class SparseStructuresValue
    extends BaseValue<SparseStructuresConfig> {
        protected SparseStructuresValue(@Nullable SNBTConfig c, String n, SparseStructuresConfig def) {
            super(c, n, (Object)def);
        }

        public void write(SNBTCompoundTag compoundTag) {
            SNBTCompoundTag tag = new SNBTCompoundTag();
            tag.comment("enabled", "Whether sparse structures are enabled.");
            tag.putBoolean("enabled", ((SparseStructuresConfig)this.get()).enabled);
            tag.comment("global_spread_factor", "The global spread factor for all structures when no custom spread factor is defined.");
            tag.putDouble("global_spread_factor", ((SparseStructuresConfig)this.get()).globalSpreadFactor);
            ListTag list = new ListTag();
            for (CustomSpreadFactors custom : ((SparseStructuresConfig)this.get()).customSpreadFactors) {
                SNBTCompoundTag customTag = new SNBTCompoundTag();
                customTag.putString("structure", custom.structure);
                customTag.putDouble("spread_factor", custom.spreadFactor);
                list.add((Object)customTag);
            }
            tag.comment("custom_spread_factors", "Custom spread factors for specific structures.");
            tag.put("custom_spread_factors", (Tag)list);
            compoundTag.comment(this.key, "Sparse structures configuration. See https://github.com/MCTeamPotato/SparseStructuresReforged/tree/1201 for more information.");
            compoundTag.put(this.key, (Tag)tag);
        }

        public void read(SNBTCompoundTag parent) {
            if (!parent.contains(this.key)) {
                this.set(SparseStructuresConfig.DEFAULT);
                return;
            }
            SNBTCompoundTag tag = (SNBTCompoundTag)parent.get(this.key);
            if (tag == null) {
                this.set(SparseStructuresConfig.DEFAULT);
                return;
            }
            boolean enabled = tag.getBoolean("enabled");
            double globalSpreadFactor = tag.getDouble("global_spread_factor");
            ArrayList<CustomSpreadFactors> customSpreadFactors = new ArrayList<CustomSpreadFactors>();
            if (tag.contains("custom_spread_factors")) {
                ListTag listTag = tag.getList("custom_spread_factors", 10);
                for (Tag customTag : listTag) {
                    SNBTCompoundTag compound = (SNBTCompoundTag)customTag;
                    customSpreadFactors.add(new CustomSpreadFactors(compound.getString("structure"), compound.getDouble("spread_factor")));
                }
            }
            this.set(new SparseStructuresConfig(enabled, globalSpreadFactor, customSpreadFactors));
        }
    }

    public record SparseStructuresConfig(boolean enabled, double globalSpreadFactor, List<CustomSpreadFactors> customSpreadFactors) {
        public static final SparseStructuresConfig DEFAULT = new SparseStructuresConfig(false, 2.0, new ArrayList<CustomSpreadFactors>());
    }

    public record CustomSpreadFactors(String structure, double spreadFactor) {
    }
}

