/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import dev.latvian.mods.kubejs.mekanism.MekanismChemicalWrapper;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;

public interface ChemicalComponents {
    public static final RecipeComponent<Chemical> CHEMICAL = new SimpleRecipeComponent<Chemical>("mekanism:chemical", Chemical.CODEC, MekanismChemicalWrapper.CHEMICAL_TYPE_INFO){

        public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
            return ChemicalComponents.isChemicalLike(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(Context cx, KubeRecipe recipe, Chemical value, ReplacementMatchInfo match) {
            ReplacementMatch replacementMatch = match.match();
            if (!(replacementMatch instanceof ChemicalIngredient)) return false;
            ChemicalIngredient m = (ChemicalIngredient)replacementMatch;
            if (value.isEmptyType()) return false;
            if (!m.test(value)) return false;
            return true;
        }

        public boolean isEmpty(Chemical value) {
            return value.isEmptyType();
        }

        public void buildUniqueId(UniqueIdBuilder builder, Chemical value) {
            builder.append(value.getRegistryName());
        }
    };
    public static final RecipeComponent<ChemicalStack> CHEMICAL_STACK = new SimpleRecipeComponent<ChemicalStack>("mekanism:chemical_stack", ChemicalStack.OPTIONAL_CODEC, MekanismChemicalWrapper.CHEMICAL_STACK_TYPE_INFO){

        public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
            return ChemicalComponents.isChemicalLike(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(Context cx, KubeRecipe recipe, ChemicalStack value, ReplacementMatchInfo match) {
            ReplacementMatch replacementMatch = match.match();
            if (!(replacementMatch instanceof ChemicalIngredient)) return false;
            ChemicalIngredient m = (ChemicalIngredient)replacementMatch;
            if (value.isEmpty()) return false;
            if (!m.test(value.getChemical())) return false;
            return true;
        }

        public boolean isEmpty(ChemicalStack value) {
            return value.isEmpty();
        }

        public void buildUniqueId(UniqueIdBuilder builder, ChemicalStack value) {
            builder.append(value.getTypeRegistryName());
        }
    };
    public static final RecipeComponent<ChemicalIngredient> CHEMICAL_INGREDIENT = new SimpleRecipeComponent<ChemicalIngredient>("mekanism:chemical_ingredient", IngredientCreatorAccess.chemical().codec(), MekanismChemicalWrapper.CHEMICAL_INGREDIENT_TYPE_INFO){

        public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
            return ChemicalComponents.isChemicalLike(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(Context cx, KubeRecipe recipe, ChemicalIngredient value, ReplacementMatchInfo match) {
            ReplacementMatch replacementMatch = match.match();
            if (!(replacementMatch instanceof ChemicalIngredient)) return false;
            ChemicalIngredient m = (ChemicalIngredient)replacementMatch;
            if (value.isEmpty()) return false;
            if (!value.getChemicals().stream().anyMatch(m)) return false;
            return true;
        }

        public boolean isEmpty(ChemicalIngredient value) {
            return value.isEmpty();
        }

        public void buildUniqueId(UniqueIdBuilder builder, ChemicalIngredient value) {
            if (value instanceof CompoundChemicalIngredient) {
                CompoundChemicalIngredient c = (CompoundChemicalIngredient)value;
                boolean first = true;
                for (ChemicalIngredient in : c.children()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.appendSeparator();
                    }
                    this.buildUniqueId(builder, in);
                }
            } else if (value instanceof TagChemicalIngredient) {
                TagChemicalIngredient tag = (TagChemicalIngredient)value;
                builder.append(tag.tag().location());
            } else {
                List list = value.getChemicals();
                if (!list.isEmpty()) {
                    builder.append(((Chemical)list.getFirst()).getRegistryName());
                }
            }
        }
    };
    public static final RecipeComponent<ChemicalStackIngredient> CHEMICAL_STACK_INGREDIENT = new SimpleRecipeComponent<ChemicalStackIngredient>("mekanism:chemical_stack_ingredient", ChemicalStackIngredient.CODEC, MekanismChemicalWrapper.CHEMICAL_STACK_INGREDIENT_TYPE_INFO){

        public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
            return ChemicalComponents.isChemicalLike(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matches(Context cx, KubeRecipe recipe, ChemicalStackIngredient value, ReplacementMatchInfo match) {
            ReplacementMatch replacementMatch = match.match();
            if (!(replacementMatch instanceof ChemicalIngredient)) return false;
            ChemicalIngredient m = (ChemicalIngredient)replacementMatch;
            if (value.ingredient().isEmpty()) return false;
            if (!value.ingredient().getChemicals().stream().anyMatch(m)) return false;
            return true;
        }

        public boolean isEmpty(ChemicalStackIngredient value) {
            return value.ingredient().isEmpty();
        }

        public void buildUniqueId(UniqueIdBuilder builder, ChemicalStackIngredient value) {
            CHEMICAL_INGREDIENT.buildUniqueId(builder, (Object)value.ingredient());
        }
    };

    private static boolean isChemicalLike(Object obj) {
        return obj instanceof Chemical || obj instanceof ChemicalStack || obj instanceof ChemicalIngredient || obj instanceof ChemicalStackIngredient;
    }
}

