/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.recipetypes.serializer;

import com.devdyna.justdynathings.recipetypes.type.ReforgerMTORecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.crafting.BlockTagIngredient;

public class ReforgerMTORecipeSerializer
implements RecipeSerializer<ReforgerMTORecipe> {
    public static final MapCodec<ReforgerMTORecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockTagIngredient.CODEC.fieldOf("input").forGetter(ReforgerMTORecipe::getInputState), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(ReforgerMTORecipe::getCatalyst), (App)Codec.intRange((int)0, (int)100).fieldOf("chanceToUse").forGetter(ReforgerMTORecipe::getChanceToUse), (App)BlockState.CODEC.fieldOf("output").forGetter(ReforgerMTORecipe::getOutputState)).apply((Applicative)inst, ReforgerMTORecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ReforgerMTORecipe> STREAM_CODEC = StreamCodec.of(ReforgerMTORecipeSerializer::toNetwork, ReforgerMTORecipeSerializer::fromNetwork);

    public static ReforgerMTORecipe fromNetwork(RegistryFriendlyByteBuf buf) {
        BlockTagIngredient inputState = new BlockTagIngredient(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)buf.readResourceLocation()));
        Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
        BlockState outputState = Block.stateById((int)buf.readInt());
        int chanceToUse = buf.readInt();
        return new ReforgerMTORecipe(inputState, catalyst, chanceToUse, outputState);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buf, ReforgerMTORecipe recipe) {
        buf.writeResourceLocation(recipe.getInputState().getTag().location());
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getCatalyst());
        buf.writeInt(Block.getId((BlockState)recipe.getOutputState()));
        buf.writeInt(recipe.getChanceToUse());
    }

    public MapCodec<ReforgerMTORecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ReforgerMTORecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

