/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.registry.types.zBlockTags;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.direwolf20.justdirethings.common.blockentities.BlockSwapperT1BE;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SwapperWand
extends Item {
    public SwapperWand() {
        super(zProperties.iProp.component((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS, null).stacksTo(1).durability(256));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        if (item.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS) != null) {
            item.set((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS, null);
            player.displayClientMessage((Component)Component.translatable((String)"justdynathings.clear_pos"), true);
            player.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
            return InteractionResultHolder.success((Object)item);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext c) {
        Level level = c.getLevel();
        BlockPos pos = c.getClickedPos();
        ItemStack item = c.getItemInHand();
        Player player = c.getPlayer();
        BlockState state = level.getBlockState(pos);
        if (c.getHand() != InteractionHand.OFF_HAND) {
            GlobalPos globalPos = (GlobalPos)item.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS);
            if (level.getBlockEntity(pos) == null && !level.getBlockState(pos).is(zBlockTags.SWAPPER_DENY)) {
                if (globalPos == null) {
                    this.bindGPos(item, player, level, pos);
                } else {
                    this.swapBlocks(player, item, level, state, pos);
                }
            } else {
                this.pickUpFail(player);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(c);
    }

    private void bindGPos(ItemStack item, Player player, Level level, BlockPos pos) {
        item.set((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS, (Object)new GlobalPos(level.dimension(), pos));
        player.playSound(SoundEvents.END_PORTAL_FRAME_FILL, 1.0f, 1.0f);
    }

    private void swapBlocks(Player player, ItemStack item, Level level, BlockState state, BlockPos pos) {
        BlockPos wandPos = ((GlobalPos)item.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).pos();
        if (level.getBlockEntity(wandPos) != null || level.getBlockState(wandPos).is(zBlockTags.SWAPPER_DENY)) {
            this.swapFail(player);
            return;
        }
        BlockState transmit = level.getBlockState(((GlobalPos)item.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).pos());
        BlockState recieve = state;
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(wandPos, recieve);
            level.setBlockAndUpdate(pos, transmit);
            BlockSwapperT1BE.teleportParticles((ServerLevel)((ServerLevel)level), (BlockPos)wandPos);
            BlockSwapperT1BE.teleportParticles((ServerLevel)((ServerLevel)level), (BlockPos)pos);
            level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 512);
            level.markAndNotifyBlock(wandPos, level.getChunkAt(wandPos), state, state, 3, 512);
        }
        player.playSound(SoundEvents.END_PORTAL_FRAME_FILL, 3.0f, 0.25f);
        item.set((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS, null);
        this.consumeDurability(player, item);
    }

    private void failPlace(Player player) {
        player.playSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM);
    }

    private void pickUpFail(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"justdynathings.invalid_block"), true);
        this.failPlace(player);
    }

    private void swapFail(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"justdynathings.init_invalid"), true);
        this.failPlace(player);
    }

    private void consumeDurability(Player player, ItemStack item) {
        if (!player.isCreative()) {
            if (item.getMaxDamage() - item.getDamageValue() == 1) {
                item.shrink(1);
                player.playSound(SoundEvents.ITEM_BREAK);
            } else {
                item.setDamageValue(item.getDamageValue() + 1);
            }
        }
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("justdynathings." + Constants.Items.Swapper)));
        if (i.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS) != null) {
            t.add((Component)Component.translatable((String)"justdynathings.wand.dimension").append((Component)Component.literal((String)((GlobalPos)i.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).dimension().registry().toString()).withStyle(ChatFormatting.GREEN)));
            t.add((Component)Component.translatable((String)"justdynathings.wand.pos").append((Component)Component.literal((String)("" + ((GlobalPos)i.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).pos().getX())).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" " + ((GlobalPos)i.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).pos().getY())).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" " + ((GlobalPos)i.get((Supplier)JustDireDataComponents.BOUND_GLOBAL_POS)).pos().getZ())).withStyle(ChatFormatting.AQUA)));
        }
    }
}

