/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.ferricore_clock;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.client.builder.clock.ClockGUI;
import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.builders.ferricore_clock.ClockBE;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.Actions;
import com.devdyna.justdynathings.utils.DirectionUtil;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ClockBlock
extends BaseMachineBlock {
    public ClockBlock() {
        super(zProperties.MachineProp.sound(SoundType.COPPER_BULB));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Boolean value = (Boolean)state.getValue((Property)((BooleanProperty)DirectionUtil.StateByDir(hitResult.getDirection())));
        ItemStack item = player.getMainHandItem();
        if (player.isCrouching() && (!((Boolean)common.FERRICORE_CLOCK_WRENCHABLE.get()).booleanValue() || item.is(JustDireItemTags.WRENCHES) || item.is(JustDireItemTags.TOOLS_WRENCH))) {
            this.openMenu(player, pos);
            return InteractionResult.SUCCESS;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)((BooleanProperty)DirectionUtil.StateByDir(hitResult.getDirection())), (Comparable)Boolean.valueOf(value == false)));
        this.applySound(level, player, pos, value);
        return InteractionResult.SUCCESS;
    }

    public void applySound(Level l, Player p, BlockPos pos, boolean state) {
        if (LevelUtil.chance(50, l)) {
            l.playSound(p, pos, state ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS, (float)l.random.nextInt(50) + 0.01f, (float)l.random.nextInt(50) + 0.01f);
        }
    }

    protected boolean isSignalSource(BlockState s) {
        return true;
    }

    protected int getSignal(BlockState b, BlockGetter g, BlockPos p, Direction d) {
        return (Boolean)b.getValue((Property)zProperties.ACTIVE) != false && (Boolean)b.getValue((Property)((BooleanProperty)DirectionUtil.StateByDir(d.getOpposite()))) != false ? 15 : 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        for (BooleanProperty face : DirectionUtil.face) {
            this.defaultBlockState().setValue((Property)face, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        for (BooleanProperty face : DirectionUtil.face) {
            b.add(new Property[]{face});
        }
        b.add(new Property[]{zProperties.ACTIVE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ClockBE(pos, state);
    }

    public void openMenu(Player player, BlockPos blockPos) {
        Actions.openMenu(player, (windowId, playerInventory, playerEntity) -> new ClockGUI(windowId, playerInventory, blockPos), blockPos);
    }

    public boolean isValidBE(BlockEntity b) {
        return true;
    }

    public BlockState direRotate(BlockState s, Rotation r) {
        return s;
    }

    public BlockState direRotate(BlockState s, LevelAccessor l, BlockPos p, Rotation d) {
        return s;
    }

    public BlockState rotate(BlockState s, Rotation r) {
        return s;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Constants.ModAddonCheck.docCheck && !common.DOC_WARNING.getAsBoolean()) {
            tooltipComponents.add((Component)Component.translatable((String)"justdynathings.doc.missing"));
        }
    }
}

