/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.revitalizer;

import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.interfaces.be.EnergyMachine;
import com.devdyna.justdynathings.registry.types.zBlockEntities;
import com.devdyna.justdynathings.registry.types.zBlockTags;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.LevelUtil;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.blocks.gooblocks.GooBlock_Base;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RevitalizerBE
extends BaseMachineBE
implements EnergyMachine {
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData((PoweredMachineBE)this);

    public RevitalizerBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public RevitalizerBE(BlockPos pos, BlockState state) {
        this((BlockEntityType)zBlockEntities.REVITALIZER.get(), pos, state);
    }

    public ContainerData getContainerData() {
        return this.poweredMachineData;
    }

    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)this.getData(Registration.ENERGYSTORAGE_MACHINES);
    }

    public void tickServer() {
        this.updateBlock();
        if (this.readyToConsume()) {
            if (((Boolean)common.REVITALIZER_TOGGLE_SOUND.get()).booleanValue()) {
                this.applySound();
            }
            if (LevelUtil.chance((Integer)common.REVITALIZER_CHANCE_FE_COST.get(), this.level)) {
                this.extractFEWhenPossible();
            }
            this.reviveGoo();
        }
    }

    public void updateBlock() {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)((BlockState)this.getBlockState().setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(this.canExtractFE()))).setValue((Property)zProperties.GOO_FOUND, (Comparable)Boolean.valueOf(this.checkGooTop()))).setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING))));
    }

    public void applySound() {
        if (LevelUtil.chance(50, this.level)) {
            this.level.playSound(null, this.getBlockPos(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, (float)this.level.random.nextInt(50) + 0.01f, (float)this.level.random.nextInt(50) + 0.01f);
        }
    }

    public boolean checkGooTop() {
        return this.level.getBlockState(this.getGooPos()).is(zBlockTags.REVITALIZER_GOO);
    }

    public boolean checkGooStatus() {
        return (Boolean)this.level.getBlockState(this.getGooPos()).getValue((Property)GooBlock_Base.ALIVE) == false;
    }

    public void reviveGoo() {
        if (LevelUtil.chance(25, this.level)) {
            this.level.setBlockAndUpdate(this.getGooPos(), (BlockState)this.level.getBlockState(this.getGooPos()).setValue((Property)GooBlock_Base.ALIVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean readyToConsume() {
        return (Boolean)this.getBlockState().getValue((Property)zProperties.ACTIVE) != false && (Boolean)this.getBlockState().getValue((Property)zProperties.GOO_FOUND) != false && this.checkGooStatus();
    }

    public BlockPos getGooPos() {
        return this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    }

    @Override
    public int getStandardEnergyCost() {
        return (Integer)common.REVITALIZER_FE_COST.get();
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)common.REVITALIZER_FE_CAPACITY.get();
    }
}

