/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders.thermo;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.client.builder.thermoGen.ThermoGUI;
import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.builders.thermo.ThermoBE;
import com.devdyna.justdynathings.registry.types.zProperties;
import com.devdyna.justdynathings.utils.Actions;
import com.devdyna.justdynathings.utils.ShapeUtil;
import com.direwolf20.justdirethings.common.blocks.baseblocks.BaseMachineBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThermoBlock
extends BaseMachineBlock {
    public ThermoBlock() {
        super(zProperties.MachineProp);
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)c.getClickedFace().getOpposite())).setValue((Property)zProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.FACING, zProperties.ACTIVE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new ThermoBE(p, s);
    }

    public void openMenu(Player p, BlockPos b) {
        Actions.openMenu(p, (w, i, e) -> new ThermoGUI(w, i, b), b);
    }

    public boolean isValidBE(BlockEntity b) {
        return b instanceof ThermoBE;
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        VoxelShape shape = Shapes.empty();
        switch ((Direction)s.getValue((Property)BlockStateProperties.FACING)) {
            case NORTH: {
                shape = ShapeUtil.ThermoGen.north;
                break;
            }
            case SOUTH: {
                shape = ShapeUtil.ThermoGen.south;
                break;
            }
            case EAST: {
                shape = ShapeUtil.ThermoGen.east;
                break;
            }
            case WEST: {
                shape = ShapeUtil.ThermoGen.west;
                break;
            }
            case UP: {
                shape = ShapeUtil.ThermoGen.up;
                break;
            }
            case DOWN: {
                shape = ShapeUtil.ThermoGen.down;
                break;
            }
        }
        return shape.optimize();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Constants.ModAddonCheck.docCheck && !common.DOC_WARNING.getAsBoolean()) {
            tooltipComponents.add((Component)Component.translatable((String)"justdynathings.doc.missing"));
        }
        tooltipComponents.add((Component)Component.translatable((String)("justdynathings." + Constants.Blocks.ThermoGen + ".tip")));
    }
}

