/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.utils;

import java.util.Arrays;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DirectionUtil {
    public static Direction[] ALL = Direction.values();
    public static Direction[] HORIZONTAL = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    public static int span = 18;
    public static int[][] POS = new int[][]{{2 * span, span}, {span, 0}, {span, -span}, {span, span}, {0, 0}, {2 * span, 0}};
    public static BooleanProperty[] face = new BooleanProperty[]{BlockStateProperties.DOWN, BlockStateProperties.UP, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    public static BooleanProperty[] horizontal_face = new BooleanProperty[]{BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.EAST, BlockStateProperties.WEST};

    public static Set<BlockPos> around(BlockPos p) {
        return Set.of(p.north(), p.south(), p.east(), p.west(), p.north().east(), p.north().west(), p.south().east(), p.south().west());
    }

    public static int indexByDir(Direction d) {
        return Arrays.asList(ALL).indexOf(d);
    }

    public static Property<?> StateByDir(Direction d) {
        return DirectionUtil.StateByDir(d, face, ALL);
    }

    public static Property<?> StateByDir(Direction d, Property<?>[] p, Direction[] s) {
        return p[Arrays.asList(s).indexOf(d)];
    }

    public static Direction randomDirection(Level l, Direction[] d) {
        return d[l.random.nextInt(d.length)];
    }

    public static int indexByStateFacing(BlockState s) {
        return ((Direction)s.getValue((Property)BlockStateProperties.FACING)).get3DDataValue();
    }
}

