/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKeyType;
import appeng.client.gui.style.Blitter;
import appeng.util.Platform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import org.joml.Matrix4f;

public class AMChemicalStackRenderer
implements AEKeyRenderHandler<MekanismKey> {
    public static void initialize(IEventBus bus) {
        bus.addListener(event -> event.enqueueWork(() -> AEKeyRendering.register((AEKeyType)MekanismKeyType.TYPE, MekanismKey.class, (AEKeyRenderHandler)new AMChemicalStackRenderer())));
    }

    public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, MekanismKey what) {
        ChemicalStack stack = what.getStack();
        Blitter.sprite((TextureAtlasSprite)((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stack.getChemical().getIcon()))).colorRgb(stack.getChemicalTint()).blending(false).dest(x, y, 16, 16).blit(guiGraphics);
    }

    public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, MekanismKey what, float scale, int combinedLight, Level level) {
        ChemicalStack stack = what.getStack();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stack.getChemical().getIcon());
        int color = stack.getChemicalTint();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.01f);
        VertexConsumer buffer = buffers.getBuffer(RenderType.solid());
        float x0 = -(scale -= 0.05f) / 2.0f;
        float y0 = scale / 2.0f;
        float x1 = scale / 2.0f;
        float y1 = -scale / 2.0f;
        Matrix4f transform = poseStack.last().pose();
        buffer.addVertex(transform, x0, y1, 0.0f).setColor(color).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y1, 0.0f).setColor(color).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x1, y0, 0.0f).setColor(color).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        buffer.addVertex(transform, x0, y0, 0.0f).setColor(color).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(0.0f, 0.0f, 1.0f);
        poseStack.popPose();
    }

    public Component getDisplayName(MekanismKey stack) {
        return stack.getDisplayName();
    }

    public List<Component> getTooltip(MekanismKey stack) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName(stack));
        stack.getStack().appendHoverText(Item.TooltipContext.EMPTY, tooltip, (TooltipFlag)TooltipFlag.NORMAL);
        String modName = Platform.formatModName((String)stack.getModId());
        if (tooltip.isEmpty() || !((Component)tooltip.getLast()).getString().equals(modName)) {
            tooltip.add((Component)Component.literal((String)modName));
        }
        return tooltip;
    }
}

