/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.EnumUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;
import top.theillusivec4.curios.api.type.ICuriosMenu;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.inventory.DynamicStackHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncActiveState;

public class CurioStacksHandler
implements ICurioStacksHandler {
    private static final ResourceLocation LEGACY_ID = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"legacy");
    private final ICuriosItemHandler itemHandler;
    private final String identifier;
    private final Map<ResourceLocation, AttributeModifier> modifiers = new HashMap<ResourceLocation, AttributeModifier>();
    private final Map<ResourceLocation, AttributeModifier> persistentModifiers = new HashMap<ResourceLocation, AttributeModifier>();
    private final Map<ResourceLocation, AttributeModifier> cachedModifiers = new HashMap<ResourceLocation, AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    private int baseSize;
    private final IDynamicStackHandler stackHandler;
    private final IDynamicStackHandler cosmeticStackHandler;
    private boolean visible;
    private boolean cosmetic;
    private boolean canToggleRender;
    private ICurio.DropRule dropRule;
    private boolean update;
    private NonNullList<Boolean> renderHandler;
    private NonNullList<Boolean> activeStates;
    private NonNullList<Boolean> previousActiveStates;
    private int clearCacheTick = -1;

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier) {
        this(itemHandler, identifier, 1, true, false, true, ICurio.DropRule.DEFAULT);
    }

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier, int size, boolean visible, boolean cosmetic, boolean canToggleRender, ICurio.DropRule dropRule) {
        this.baseSize = size;
        this.visible = visible;
        this.cosmetic = cosmetic;
        this.itemHandler = itemHandler;
        this.identifier = identifier;
        this.canToggleRender = canToggleRender;
        this.dropRule = dropRule;
        this.renderHandler = NonNullList.withSize((int)size, (Object)true);
        this.activeStates = NonNullList.withSize((int)size, (Object)true);
        this.previousActiveStates = NonNullList.withSize((int)size, (Object)true);
        this.stackHandler = new DynamicStackHandler(size, index -> new SlotContext(identifier, itemHandler.getWearer(), (int)index, false, (Boolean)this.getRenders().get(index.intValue())));
        this.cosmeticStackHandler = new DynamicStackHandler(size, index -> new SlotContext(identifier, itemHandler.getWearer(), (int)index, true, (Boolean)this.getRenders().get(index.intValue())));
    }

    @Override
    public IDynamicStackHandler getStacks() {
        this.update();
        return this.stackHandler;
    }

    @Override
    public IDynamicStackHandler getCosmeticStacks() {
        this.update();
        return this.cosmeticStackHandler;
    }

    @Override
    public NonNullList<Boolean> getRenders() {
        this.update();
        return this.renderHandler;
    }

    @Override
    public NonNullList<Boolean> getActiveStates() {
        this.update();
        return this.activeStates;
    }

    @Override
    public void updateActiveState(int index) {
        this.update();
        LivingEntity livingEntity = this.itemHandler.getWearer();
        if (livingEntity != null && !livingEntity.level().isClientSide()) {
            boolean previous;
            if (this.activeStates.size() <= index) {
                return;
            }
            boolean current = (Boolean)this.activeStates.get(index);
            if (current == (previous = ((Boolean)this.previousActiveStates.get(index)).booleanValue())) {
                return;
            }
            if (!previous) {
                this.activateSlot(index);
            } else {
                this.deactivateSlot(index);
            }
        }
    }

    private void deactivateSlot(int index) {
        this.previousActiveStates.set(index, (Object)false);
        LivingEntity livingEntity = this.itemHandler.getWearer();
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncActiveState(livingEntity.getId(), this.identifier, index, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        NonNullList<Boolean> renderStates = this.getRenders();
        SlotContext slotContext = new SlotContext(this.identifier, livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false);
        IDynamicStackHandler stacks = this.getStacks();
        ItemStack stack = stacks.getStackInSlot(index);
        NeoForge.EVENT_BUS.post((Event)new CurioChangeEvent(livingEntity, this.identifier, index, stack, ItemStack.EMPTY));
        ResourceLocation id = CuriosApi.getSlotId(slotContext);
        AttributeMap attributeMap = livingEntity.getAttributes();
        if (!stack.isEmpty()) {
            Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, id, stack);
            HashMultimap slots = HashMultimap.create();
            HashSet<Holder> toRemove = new HashSet<Holder>();
            for (Holder attribute : map.keySet()) {
                Object object = attribute.value();
                if (!(object instanceof SlotAttribute)) continue;
                SlotAttribute wrapper = (SlotAttribute)((Object)object);
                slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                toRemove.add(attribute);
            }
            for (Holder attribute : toRemove) {
                map.removeAll((Object)attribute);
            }
            map.forEach((key, value) -> {
                AttributeInstance attInst = attributeMap.getInstance(key);
                if (attInst != null) {
                    attInst.removeModifier(value);
                }
            });
            this.itemHandler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
            CuriosApi.getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, stack));
        }
    }

    private void activateSlot(int index) {
        this.previousActiveStates.set(index, (Object)true);
        LivingEntity livingEntity = this.itemHandler.getWearer();
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncActiveState(livingEntity.getId(), this.identifier, index, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        NonNullList<Boolean> renderStates = this.getRenders();
        SlotContext slotContext = new SlotContext(this.identifier, livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false);
        IDynamicStackHandler stacks = this.getStacks();
        ItemStack stack = stacks.getStackInSlot(index);
        NeoForge.EVENT_BUS.post((Event)new CurioChangeEvent(livingEntity, this.identifier, index, ItemStack.EMPTY, stack));
        ResourceLocation id = CuriosApi.getSlotId(slotContext);
        AttributeMap attributeMap = livingEntity.getAttributes();
        if (!stack.isEmpty()) {
            Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, id, stack);
            HashMultimap slots = HashMultimap.create();
            HashSet<Holder> toRemove = new HashSet<Holder>();
            for (Holder attribute : map.keySet()) {
                Object object = attribute.value();
                if (!(object instanceof SlotAttribute)) continue;
                SlotAttribute wrapper = (SlotAttribute)((Object)object);
                slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                toRemove.add(attribute);
            }
            for (Holder attribute : toRemove) {
                map.removeAll((Object)attribute);
            }
            map.forEach((key, value) -> {
                AttributeInstance attInst = attributeMap.getInstance(key);
                if (attInst != null) {
                    attInst.addOrUpdateTransientModifier(value);
                }
            });
            this.itemHandler.addTransientSlotModifiers((Multimap<String, AttributeModifier>)slots);
            CuriosApi.getCurio(stack).ifPresent(curio -> curio.onEquip(slotContext, ItemStack.EMPTY));
            if (livingEntity instanceof ServerPlayer) {
                CuriosRegistry.EQUIP_TRIGGER.get().trigger(slotContext, (ServerPlayer)livingEntity, stack);
            }
        }
    }

    @Override
    public boolean canToggleRendering() {
        return this.canToggleRender;
    }

    @Override
    public ICurio.DropRule getDropRule() {
        return this.dropRule;
    }

    @Override
    public int getSlots() {
        this.update();
        return this.stackHandler.getSlots();
    }

    @Override
    public int getSizeShift() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    @Override
    public void grow(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(amount);
        }
    }

    @Override
    public void shrink(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(Math.min(this.getSlots(), amount) * -1);
        }
    }

    private void addLegacyChange(int shift) {
        AttributeModifier mod = this.getModifiers().get(LEGACY_ID);
        int current = mod != null ? (int)mod.amount() : 0;
        AttributeModifier newModifier = new AttributeModifier(LEGACY_ID, (double)(current += shift), AttributeModifier.Operation.ADD_VALUE);
        this.modifiers.put(newModifier.id(), newModifier);
        Collection<AttributeModifier> modifiers = this.getModifiersByOperation(newModifier.operation());
        ArrayList<AttributeModifier> ops = new ArrayList<AttributeModifier>(modifiers);
        for (AttributeModifier op : ops) {
            if (!op.id().equals((Object)newModifier.id())) continue;
            modifiers.remove(op);
        }
        modifiers.add(newModifier);
        this.persistentModifiers.remove(newModifier.id());
        this.persistentModifiers.put(newModifier.id(), newModifier);
        this.flagUpdate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("SavedBaseSize", this.baseSize);
        compoundNBT.put("Stacks", (Tag)this.stackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        compoundNBT.put("Cosmetics", (Tag)this.cosmeticStackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Renders", (Tag)nbtTagList);
        nbt.putInt("Size", this.renderHandler.size());
        compoundNBT.put("Renders", (Tag)nbt);
        nbtTagList = new ListTag();
        for (int i = 0; i < this.activeStates.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("ActiveState", ((Boolean)this.activeStates.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        nbt = new CompoundTag();
        nbt.put("ActiveStates", (Tag)nbtTagList);
        nbt.putInt("Size", this.activeStates.size());
        compoundNBT.put("ActiveStates", (Tag)nbt);
        compoundNBT.putBoolean("HasCosmetic", this.cosmetic);
        compoundNBT.putBoolean("Visible", this.visible);
        compoundNBT.putBoolean("RenderToggle", this.canToggleRender);
        compoundNBT.putString("DropRule", this.dropRule.toString());
        if (!this.persistentModifiers.isEmpty()) {
            ListTag list = new ListTag();
            for (AttributeModifier attributeModifier : this.persistentModifiers.values()) {
                list.add((Object)attributeModifier.save());
            }
            compoundNBT.put("PersistentModifiers", (Tag)list);
        }
        if (!this.modifiers.isEmpty()) {
            ListTag list = new ListTag();
            this.modifiers.forEach((uuid, modifier) -> {
                if (!this.persistentModifiers.containsKey(modifier.id())) {
                    list.add((Object)modifier.save());
                }
            });
            compoundNBT.put("CachedModifiers", (Tag)list);
        }
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        int sizeShift;
        int slot;
        CompoundTag tags;
        int i;
        ListTag tagList;
        CompoundTag tag;
        if (nbt.contains("SavedBaseSize")) {
            this.baseSize = nbt.getInt("SavedBaseSize");
        }
        if (nbt.contains("Stacks")) {
            this.stackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), nbt.getCompound("Stacks"));
        }
        if (nbt.contains("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), nbt.getCompound("Cosmetics"));
        }
        if (nbt.contains("Renders")) {
            tag = nbt.getCompound("Renders");
            this.renderHandler = NonNullList.withSize((int)(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            tagList = tag.getList("Renders", 10);
            for (i = 0; i < tagList.size(); ++i) {
                tags = tagList.getCompound(i);
                slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.getBoolean("Render"));
            }
        }
        if (nbt.contains("ActiveStates")) {
            tag = nbt.getCompound("ActiveStates");
            this.activeStates = NonNullList.withSize((int)(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            this.previousActiveStates = NonNullList.withSize((int)(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            tagList = tag.getList("ActiveStates", 10);
            for (i = 0; i < tagList.size(); ++i) {
                tags = tagList.getCompound(i);
                slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.activeStates.size()) continue;
                this.activeStates.set(slot, (Object)tags.getBoolean("ActiveState"));
                this.previousActiveStates.set(slot, (Object)tags.getBoolean("ActiveState"));
            }
        }
        if (nbt.contains("SizeShift") && (sizeShift = nbt.getInt("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = nbt.contains("HasCosmetic") ? nbt.getBoolean("HasCosmetic") : this.cosmetic;
        this.visible = nbt.contains("Visible") ? nbt.getBoolean("Visible") : this.visible;
        boolean bl = this.canToggleRender = nbt.contains("RenderToggle") ? nbt.getBoolean("RenderToggle") : this.canToggleRender;
        if (nbt.contains("DropRule")) {
            this.dropRule = (ICurio.DropRule)EnumUtils.getEnum(ICurio.DropRule.class, (String)nbt.getString("DropRule"), (Enum)this.dropRule);
        }
        if (nbt.contains("PersistentModifiers", 9)) {
            ListTag list = nbt.getList("PersistentModifiers", 10);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i2));
                if (attributeModifier == null) continue;
                this.addPermanentModifier(attributeModifier);
            }
        }
        if (nbt.contains("CachedModifiers", 9)) {
            ListTag list = nbt.getList("CachedModifiers", 10);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i3));
                if (attributeModifier == null) continue;
                this.cachedModifiers.put(attributeModifier.id(), attributeModifier);
                this.addTransientModifier(attributeModifier);
            }
        }
        this.update();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CompoundTag getSyncTag() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("Stacks", (Tag)this.stackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        compoundNBT.put("Cosmetics", (Tag)this.cosmeticStackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Renders", (Tag)nbtTagList);
        nbt.putInt("Size", this.renderHandler.size());
        compoundNBT.put("Renders", (Tag)nbt);
        nbtTagList = new ListTag();
        for (int i = 0; i < this.activeStates.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("ActiveState", ((Boolean)this.activeStates.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        nbt = new CompoundTag();
        nbt.put("ActiveStates", (Tag)nbtTagList);
        nbt.putInt("Size", this.activeStates.size());
        compoundNBT.put("ActiveStates", (Tag)nbt);
        compoundNBT.putBoolean("HasCosmetic", this.cosmetic);
        compoundNBT.putBoolean("Visible", this.visible);
        compoundNBT.putBoolean("RenderToggle", this.canToggleRender);
        compoundNBT.putString("DropRule", this.dropRule.toString());
        compoundNBT.putInt("BaseSize", this.baseSize);
        if (!this.modifiers.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<ResourceLocation, AttributeModifier> modifier : this.modifiers.entrySet()) {
                list.add((Object)modifier.getValue().save());
            }
            compoundNBT.put("Modifiers", (Tag)list);
        }
        return compoundNBT;
    }

    @Override
    public void applySyncTag(CompoundTag tag) {
        int sizeShift;
        int slot;
        CompoundTag tags;
        int i;
        ListTag tagList;
        CompoundTag compoundNBT;
        if (tag.contains("BaseSize")) {
            this.baseSize = tag.getInt("BaseSize");
        }
        if (tag.contains("Stacks")) {
            this.stackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), tag.getCompound("Stacks"));
        }
        if (tag.contains("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), tag.getCompound("Cosmetics"));
        }
        if (tag.contains("Renders")) {
            compoundNBT = tag.getCompound("Renders");
            this.renderHandler = NonNullList.withSize((int)(compoundNBT.contains("Size", 3) ? compoundNBT.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            tagList = compoundNBT.getList("Renders", 10);
            for (i = 0; i < tagList.size(); ++i) {
                tags = tagList.getCompound(i);
                slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.getBoolean("Render"));
            }
        }
        if (tag.contains("ActiveStates")) {
            compoundNBT = tag.getCompound("ActiveStates");
            this.activeStates = NonNullList.withSize((int)(compoundNBT.contains("Size", 3) ? compoundNBT.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            this.previousActiveStates = NonNullList.withSize((int)(compoundNBT.contains("Size", 3) ? compoundNBT.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            tagList = compoundNBT.getList("ActiveStates", 10);
            for (i = 0; i < tagList.size(); ++i) {
                tags = tagList.getCompound(i);
                slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.activeStates.size()) continue;
                this.activeStates.set(slot, (Object)tags.getBoolean("ActiveState"));
                this.previousActiveStates.set(slot, (Object)tags.getBoolean("ActiveState"));
            }
        }
        if (tag.contains("SizeShift") && (sizeShift = tag.getInt("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = tag.contains("HasCosmetic") ? tag.getBoolean("HasCosmetic") : this.cosmetic;
        this.visible = tag.contains("Visible") ? tag.getBoolean("Visible") : this.visible;
        boolean bl = this.canToggleRender = tag.contains("RenderToggle") ? tag.getBoolean("RenderToggle") : this.canToggleRender;
        if (tag.contains("DropRule")) {
            this.dropRule = (ICurio.DropRule)EnumUtils.getEnum(ICurio.DropRule.class, (String)tag.getString("DropRule"), (Enum)this.dropRule);
        }
        this.modifiers.clear();
        this.persistentModifiers.clear();
        this.modifiersByOperation.clear();
        if (tag.contains("Modifiers", 9)) {
            ListTag list = tag.getList("Modifiers", 10);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i2));
                if (attributeModifier == null) continue;
                this.addTransientModifier(attributeModifier);
            }
        }
        this.flagUpdate();
        this.update();
    }

    @Override
    public void copyModifiers(ICurioStacksHandler other) {
        this.modifiers.clear();
        this.cachedModifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.getModifiers().forEach((uuid, modifier) -> this.addTransientModifier((AttributeModifier)modifier));
        for (AttributeModifier cachedModifier : other.getCachedModifiers()) {
            this.cachedModifiers.put(cachedModifier.id(), cachedModifier);
        }
        for (AttributeModifier persistentModifier : other.getPermanentModifiers()) {
            this.addPermanentModifier(persistentModifier);
        }
        this.update();
    }

    @Override
    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<AttributeModifier> getPermanentModifiers() {
        return new HashSet<AttributeModifier>(this.persistentModifiers.values());
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return new HashSet<AttributeModifier>(this.cachedModifiers.values());
    }

    @Override
    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.id(), modifier);
        this.getModifiersByOperation(modifier.operation()).add(modifier);
        this.flagUpdate();
    }

    @Override
    public void addPermanentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.put(modifier.id(), modifier);
    }

    @Override
    public void removeModifier(ResourceLocation id) {
        AttributeModifier modifier = this.modifiers.remove(id);
        if (modifier != null) {
            this.persistentModifiers.remove(modifier.id(), modifier);
            Collection<AttributeModifier> modifiers = this.getModifiersByOperation(modifier.operation());
            ArrayList<AttributeModifier> ops = new ArrayList<AttributeModifier>(modifiers);
            for (AttributeModifier op : ops) {
                if (!op.id().equals((Object)id)) continue;
                modifiers.remove(op);
            }
            this.flagUpdate();
        }
    }

    private void flagUpdate() {
        this.update = true;
        if (this.itemHandler != null) {
            this.itemHandler.getUpdatingInventories().remove(this);
            this.itemHandler.getUpdatingInventories().add(this);
        }
    }

    @Override
    public void clearModifiers() {
        HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>(this.modifiers.keySet());
        for (ResourceLocation id : ids) {
            this.removeModifier(id);
        }
    }

    @Override
    public void clearCachedModifiers() {
        LivingEntity livingEntity;
        for (AttributeModifier cachedModifier : this.cachedModifiers.values()) {
            this.removeModifier(cachedModifier.id());
        }
        this.cachedModifiers.clear();
        this.flagUpdate();
        if (this.itemHandler != null && (livingEntity = this.itemHandler.getWearer()) instanceof LivingEntity) {
            LivingEntity livingEntity2 = livingEntity;
            this.clearCacheTick = livingEntity2.tickCount;
        } else {
            this.clearCacheTick = -1;
        }
    }

    @Override
    public void update() {
        block10: {
            block12: {
                block11: {
                    LivingEntity livingEntity;
                    if (!this.update) break block10;
                    if (this.itemHandler == null || !((livingEntity = this.itemHandler.getWearer()) instanceof LivingEntity)) break block11;
                    LivingEntity livingEntity2 = livingEntity;
                    if (this.clearCacheTick != livingEntity2.tickCount) break block12;
                }
                return;
            }
            this.update = false;
            double baseSize = this.baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_VALUE)) {
                baseSize += mod.amount();
            }
            double size = baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                size += (double)this.baseSize * mod.amount();
            }
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                size *= mod.amount();
            }
            if ((size = Math.max(0.0, size)) != (double)this.getSlots()) {
                this.resize((int)size);
                if (this.itemHandler != null && this.itemHandler.getWearer() != null) {
                    NeoForge.EVENT_BUS.post((Event)new SlotModifiersUpdatedEvent(this.itemHandler.getWearer(), Set.of(this.identifier)));
                    LivingEntity livingEntity = this.itemHandler.getWearer();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        livingEntity = player.containerMenu;
                        if (livingEntity instanceof ICuriosMenu) {
                            ICuriosMenu curiosMenu = (ICuriosMenu)livingEntity;
                            curiosMenu.resetSlots();
                        }
                    }
                }
            }
        }
    }

    private void resize(int newSize) {
        block8: {
            int currentSize = this.getSlots();
            if (currentSize == newSize) break block8;
            int change = newSize - currentSize;
            if (currentSize > newSize) {
                int i;
                this.loseStacks(this.stackHandler, this.identifier, change *= -1);
                this.stackHandler.shrink(change);
                this.cosmeticStackHandler.shrink(change);
                NonNullList newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
                newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (i = 0; i < newList.size() && i < this.activeStates.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.activeStates.get(i)));
                }
                this.activeStates = newList;
                this.previousActiveStates = NonNullList.create();
                for (i = 0; i < this.activeStates.size(); ++i) {
                    this.previousActiveStates.add(i, (Object)((Boolean)this.activeStates.get(i)));
                }
            } else {
                int i;
                this.stackHandler.grow(change);
                this.cosmeticStackHandler.grow(change);
                NonNullList newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
                newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (i = 0; i < newList.size() && i < this.activeStates.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.activeStates.get(i)));
                }
                this.activeStates = newList;
                this.previousActiveStates = NonNullList.create();
                for (i = 0; i < this.activeStates.size(); ++i) {
                    this.previousActiveStates.add(i, (Object)((Boolean)this.activeStates.get(i)));
                }
            }
        }
    }

    private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
        if (this.itemHandler == null) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = Math.max(0, stackHandler.getSlots() - amount); i >= 0 && i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            drops.add(stackHandler.getStackInSlot(i));
            LivingEntity entity = this.itemHandler.getWearer();
            SlotContext slotContext = new SlotContext(identifier, entity, i, false, this.visible);
            if (!stack.isEmpty()) {
                ResourceLocation id = CuriosApi.getSlotId(slotContext);
                Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, id, stack);
                HashMultimap slots = HashMultimap.create();
                HashSet<Holder> toRemove = new HashSet<Holder>();
                AttributeMap attributeMap = entity.getAttributes();
                for (Holder attribute : map.keySet()) {
                    Object object = attribute.value();
                    if (!(object instanceof SlotAttribute)) continue;
                    SlotAttribute wrapper = (SlotAttribute)((Object)object);
                    slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                    toRemove.add(attribute);
                }
                for (Holder attribute : toRemove) {
                    map.removeAll((Object)attribute);
                }
                map.forEach((key, value) -> {
                    AttributeInstance attInst = attributeMap.getInstance(key);
                    if (attInst != null) {
                        attInst.removeModifier(value);
                    }
                });
                this.itemHandler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                CuriosApi.getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, ItemStack.EMPTY));
            }
            stackHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        drops.forEach(this.itemHandler::loseInvalidStack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurioStacksHandler that = (CurioStacksHandler)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

