/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data.recipe.enderio;

import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.enderio.machines.data.recipes.SagMillRecipeProvider;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.allthemods.alltheores.content.blocks.sets.ATOSetHelper;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class ATOEIOSagMillRecipeProvider
extends SagMillRecipeProvider
implements IConditionBuilder {
    private static final int SAG_MILL_ENERGY = 2400;

    public ATOEIOSagMillRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    private ResourceLocation sagMillDir(String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("sag_milling/" + type));
    }

    protected void buildRecipes(RecipeOutput output) {
        ATOSetHelper.applyToAlloy(set -> this.sagMillDirect(String.format("/%s/ingot", set.name), Ingredient.of(set.INGOT_TAG), this.output((ItemLike)set.DUST.get(), 1), output));
        ATOSetHelper.applyToIngot(set -> {
            this.sagMillMultiply(String.format("/%s/raw", set.name), Ingredient.of(set.RAW_TAG), Stream.of(this.output((ItemLike)set.DUST.get()), this.output((ItemLike)set.DUST.get(), 0.25f), ATORegistry.getByproducts().containsKey(set.RAW.get()) ? this.output((ItemLike)ATORegistry.getByproducts().get((Object)set.RAW.get()).first, ((Float)ATORegistry.getByproducts().get((Object)set.RAW.get()).second).floatValue()) : null).filter(Objects::nonNull).toList(), output);
            this.sagMillOre(String.format("/%s/ore", set.name), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), (Item)set.RAW.get(), output);
        });
        ATOSetHelper.applyToGem(set -> {
            this.sagMillGem(String.format("/%s/ore", set.name), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), (Item)set.GEM.get(), output);
            this.sagMillDirect(String.format("/%s/gem", set.name), Ingredient.of(set.GEM_TAG), this.output((ItemLike)set.DUST.get(), 1), output);
        });
        ATOSetHelper.applyToDust(set -> this.sagMillDirect(String.format("/%s/ore", set.name), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), this.output((ItemLike)set.DUST.get(), 6), output));
    }

    private void sagMillOre(String name, Ingredient input, Item output, RecipeOutput recipeOutput) {
        this.sagMillMultiply(name, input, List.of(this.output((ItemLike)output), this.output((ItemLike)output, 0.33f), this.output((ItemLike)Items.COBBLESTONE, 0.15f)), recipeOutput);
    }

    private void sagMillGem(String name, Ingredient input, Item output, RecipeOutput recipeOutput) {
        this.sagMillMultiply(name, input, List.of(this.output((ItemLike)output, 6), this.output((ItemLike)Items.COBBLESTONE, 0.15f)), recipeOutput);
    }

    private void sagMillMultiply(String name, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, RecipeOutput recipeOutput) {
        this.sagMill(name, input, outputs, SagMillingRecipe.BonusType.MULTIPLY_OUTPUT, recipeOutput);
    }

    private void sagMillDirect(String name, Ingredient input, SagMillingRecipe.OutputItem output, RecipeOutput recipeOutput) {
        this.sagMill(name, input, List.of(output), SagMillingRecipe.BonusType.NONE, recipeOutput);
    }

    private void sagMill(String name, Ingredient input, List<SagMillingRecipe.OutputItem> outputs, SagMillingRecipe.BonusType bonusType, RecipeOutput recipeOutput) {
        recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("enderio_machines")}).accept(this.sagMillDir(name), (Recipe)new SagMillingRecipe(input, outputs, 2400, bonusType), null);
    }
}

