/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.compat.handler;

import com.mojang.logging.LogUtils;
import me.cg360.mod.bridging.building.Bridge;
import me.cg360.mod.bridging.compat.SpecialBridgingHandler;
import me.cg360.mod.bridging.util.GameSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import tfar.dankstorage.item.DankItem;

public class DankStorageHandler
implements SpecialBridgingHandler {
    public static final DankStorageHandler INSTANCE = new DankStorageHandler();

    @Override
    public boolean canBePlaced(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof DankItem)) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            LogUtils.getLogger().warn("Blocked using DankStorage compatibility for an unsupported item (%s)!".formatted(id));
            return false;
        }
        if (!DankItem.isConstruction((ItemStack)stack)) {
            return false;
        }
        ItemStack containedStack = DankItem.getSelectedItem((ItemStack)stack);
        if (containedStack.isEmpty()) {
            return false;
        }
        return GameSupport.passesDefaultPlacementCheck(containedStack);
    }

    @Override
    public boolean canBePlacedInWorld(ItemStack stack, Player player, Level level, BlockPos pos, Direction direction) {
        ItemStack containedStack = DankItem.getSelectedItem((ItemStack)stack);
        return player.mayUseItemAt(pos, direction, containedStack);
    }

    @Override
    public BlockHitResult generatePlacementTarget(ItemStack stack, Player player, Level level, Direction direction, BlockPos pos) {
        ItemStack containedStack = DankItem.getSelectedItem((ItemStack)stack);
        return Bridge.getDefaultPlaceAssistTarget(containedStack, level, direction, pos);
    }
}

