/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import owmii.powah.Powah;
import owmii.powah.recipe.Recipes;

public class EnergizingRecipe
implements Recipe<RecipeInput> {
    public static final ResourceLocation ID = Powah.id("energizing");
    private final ItemStack output;
    private final long energy;
    private final NonNullList<Ingredient> ingredients;
    public static final MapCodec<EnergizingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.output), (App)Codec.LONG.fieldOf("energy").forGetter(e -> e.energy), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").forGetter(e -> e.ingredients)).apply((Applicative)builder, EnergizingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergizingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, EnergizingRecipe::getResultItem, (StreamCodec)ByteBufCodecs.VAR_LONG, EnergizingRecipe::getEnergy, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), EnergizingRecipe::getIngredients, EnergizingRecipe::new);

    public EnergizingRecipe(ItemStack output, long energy, List<Ingredient> ingredients) {
        this.output = output;
        this.energy = energy;
        this.ingredients = NonNullList.copyOf(ingredients);
    }

    public boolean matches(RecipeInput inv, Level world) {
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>((Collection<Ingredient>)this.getIngredients());
        for (int i = 1; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            boolean flag = false;
            Iterator itr = stacks.iterator();
            while (itr.hasNext()) {
                Ingredient ingredient = (Ingredient)itr.next();
                if (!ingredient.test(stack)) continue;
                flag = true;
                itr.remove();
                break;
            }
            if (flag) continue;
            return false;
        }
        return stacks.isEmpty();
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider registry) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Recipes.ENERGIZING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return Recipes.ENERGIZING.get();
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getScaledEnergy() {
        return Math.max(1L, (long)((double)this.energy * Powah.config().general.energizing_energy_ratio));
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<EnergizingRecipe> {
        public MapCodec<EnergizingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnergizingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

