/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.block.BaseOreBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagradditions.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagradditions.init.ModFluids;
import com.blakebr0.mysticalagradditions.item.EssenceCoalBlockItem;
import com.blakebr0.mysticalagradditions.lib.ModCropTiers;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"mysticalagradditions");
    public static final Map<String, Supplier<BlockItem>> BLOCK_ITEMS = new LinkedHashMap<String, Supplier<BlockItem>>();
    public static final DeferredHolder<Block, Block> INSANIUM_BLOCK = ModBlocks.register("insanium_block", () -> new BaseBlock(SoundType.STONE, 4.0f, 6.0f));
    public static final DeferredHolder<Block, Block> INSANIUM_INGOT_BLOCK = ModBlocks.register("insanium_ingot_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f));
    public static final DeferredHolder<Block, Block> INSANIUM_GEMSTONE_BLOCK = ModBlocks.register("insanium_gemstone_block", () -> new BaseBlock(SoundType.METAL, 5.0f, 6.0f));
    public static final DeferredHolder<Block, Block> INSANIUM_FARMLAND = ModBlocks.register("insanium_farmland", () -> new InfusedFarmlandBlock(ModCropTiers.SIX));
    public static final DeferredHolder<Block, Block> INFERIUM_COAL_BLOCK = ModBlocks.register("inferium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 21600));
    public static final DeferredHolder<Block, Block> PRUDENTIUM_COAL_BLOCK = ModBlocks.register("prudentium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 43200));
    public static final DeferredHolder<Block, Block> TERTIUM_COAL_BLOCK = ModBlocks.register("tertium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 86400));
    public static final DeferredHolder<Block, Block> IMPERIUM_COAL_BLOCK = ModBlocks.register("imperium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 172800));
    public static final DeferredHolder<Block, Block> SUPREMIUM_COAL_BLOCK = ModBlocks.register("supremium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 345600));
    public static final DeferredHolder<Block, Block> INSANIUM_COAL_BLOCK = ModBlocks.register("insanium_coal_block", () -> new BaseBlock(SoundType.STONE, 5.0f, 6.0f), block -> () -> new EssenceCoalBlockItem((Block)block.get(), 691200));
    public static final DeferredHolder<Block, Block> NETHER_PROSPERITY_ORE = ModBlocks.register("nether_prosperity_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> NETHER_INFERIUM_ORE = ModBlocks.register("nether_inferium_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> END_PROSPERITY_ORE = ModBlocks.register("end_prosperity_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> END_INFERIUM_ORE = ModBlocks.register("end_inferium_ore", () -> new BaseOreBlock(SoundType.STONE, 3.0f, 3.0f, 2, 5));
    public static final DeferredHolder<Block, Block> NETHER_STAR_CRUX = ModBlocks.register("nether_star_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> DRAGON_EGG_CRUX = ModBlocks.register("dragon_egg_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> GAIA_SPIRIT_CRUX = ModBlocks.register("gaia_spirit_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> AWAKENED_DRACONIUM_CRUX = ModBlocks.register("awakened_draconium_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> NEUTRONIUM_CRUX = ModBlocks.register("neutronium_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> NITRO_CRYSTAL_CRUX = ModBlocks.register("nitro_crystal_crux", () -> new BaseBlock(SoundType.STONE, 5.0f, 10.0f));
    public static final DeferredHolder<Block, Block> MOLTEN_INFERIUM = ModBlocks.registerNoItem("molten_inferium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_INFERIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));
    public static final DeferredHolder<Block, Block> MOLTEN_PRUDENTIUM = ModBlocks.registerNoItem("molten_prudentium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_PRUDENTIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));
    public static final DeferredHolder<Block, Block> MOLTEN_TERTIUM = ModBlocks.registerNoItem("molten_tertium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_TERTIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));
    public static final DeferredHolder<Block, Block> MOLTEN_IMPERIUM = ModBlocks.registerNoItem("molten_imperium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_IMPERIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));
    public static final DeferredHolder<Block, Block> MOLTEN_SUPREMIUM = ModBlocks.registerNoItem("molten_supremium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_SUPREMIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));
    public static final DeferredHolder<Block, Block> MOLTEN_SOULIUM = ModBlocks.registerNoItem("molten_soulium", () -> new LiquidBlock((FlowingFluid)ModFluids.MOLTEN_SOULIUM.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA)));

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get()));
    }

    private static DeferredHolder<Block, Block> register(String name, Supplier<Block> block, Function<DeferredHolder<Block, Block>, Supplier<? extends BlockItem>> item) {
        DeferredHolder reg = REGISTRY.register(name, block);
        BLOCK_ITEMS.put(name, () -> (BlockItem)((Supplier)item.apply(reg)).get());
        return reg;
    }

    private static DeferredHolder<Block, Block> registerNoItem(String name, Supplier<Block> block) {
        return REGISTRY.register(name, block);
    }
}

