/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ActiveRitualData {
    public static final Codec<ActiveRitualData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ritual.CODEC.fieldOf("ritual").forGetter(data -> data.ritual), (App)Codec.INT.fieldOf("counter").forGetter(data -> data.counter), (App)Codec.INT.fieldOf("lightning_counter").forGetter(data -> data.lightningCounter), (App)UUIDUtil.CODEC.fieldOf("started_by").forGetter(data -> data.startedBy)).apply((Applicative)instance, ActiveRitualData::new));
    private final Holder<Ritual> ritual;
    private int counter;
    private int lightningCounter;
    private final UUID startedBy;

    public ActiveRitualData(Holder<Ritual> ritual, int counter, int lightningCounter, UUID startedBy) {
        this.ritual = ritual;
        this.counter = counter;
        this.lightningCounter = lightningCounter;
        this.startedBy = startedBy;
    }

    public static ActiveRitualData create(Holder<Ritual> ritual, UUID startedBy) {
        return new ActiveRitualData(ritual, 0, 0, startedBy);
    }

    public float calculateRitualProgress() {
        return (float)this.counter / (float)((Ritual)this.ritual.value()).duration();
    }

    public Ritual getRitual() {
        return (Ritual)this.ritual.value();
    }

    public int getCounter() {
        return this.counter;
    }

    public void incrementCounter() {
        ++this.counter;
    }

    public int getLightningCounter() {
        return this.lightningCounter;
    }

    public void incrementLightningCounter() {
        ++this.lightningCounter;
    }

    public UUID getStartedBy() {
        return this.startedBy;
    }

    @Nullable
    public ResourceLocation getRitualId() {
        return this.ritual.unwrapKey().map(ResourceKey::location).orElse(null);
    }
}

