/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.items;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import appeng.util.InteractionUtil;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.caps.CellFEPower;
import com.glodblock.github.appflux.common.me.cell.FECellHandler;
import com.glodblock.github.appflux.common.me.cell.FluxCellInventory;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFECell
extends AEBaseItem
implements IFluxCell {
    private final ItemLike coreItem;
    private final long totalBytes;
    private final double idleDrain;

    public ItemFECell(ItemLike coreItem, int kilobytes, double idleDrain) {
        super(new Item.Properties().stacksTo(1));
        this.coreItem = coreItem;
        this.totalBytes = (long)kilobytes * 1024L;
        this.idleDrain = idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)1);
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.FE;
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        Preconditions.checkArgument((is.getItem() == this ? 1 : 0) != 0);
        FECellHandler.HANDLER.addCellInformationToTooltip(is, lines);
    }

    @Override
    public Optional<TooltipComponent> getCellTooltipImage(ItemStack is) {
        return FECellHandler.HANDLER.getTooltipImage(is);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!InteractionUtil.isInAlternateUseMode((Player)player)) {
            return false;
        }
        List disassembledStacks = StorageCellDisassemblyRecipe.getDisassemblyResult((Level)level, (Item)stack.getItem());
        if (disassembledStacks.isEmpty()) {
            return false;
        }
        Inventory playerInventory = player.getInventory();
        if (playerInventory.getSelected() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
        if (inv != null && !inv.getAvailableStacks().isEmpty()) {
            player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            return false;
        }
        playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
        for (ItemStack disassembledStack : disassembledStacks) {
            playerInventory.placeItemBackInInventory(disassembledStack.copy());
        }
        this.getUpgrades(stack).forEach(arg_0 -> ((Inventory)playerInventory).placeItemBackInInventory(arg_0));
        return true;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.getLevel(), context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack is, @Nullable Item.TooltipContext level, List<Component> lines, TooltipFlag tooltipFlag) {
        this.addCellInformationToTooltip(is, lines);
    }

    @Nullable
    public IEnergyStorage getCapability(@NotNull ItemStack stack, @NotNull Void context) {
        FluxCellInventory inv = FECellHandler.HANDLER.getCellInventory(stack, null);
        if (inv != null) {
            return new CellFEPower(inv);
        }
        return null;
    }
}

