/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.datagen.data;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import tfar.metalbarrels.MetalBarrels;
import tfar.metalbarrels.init.ModBlocks;
import tfar.metalbarrels.init.ModItems;
import tfar.metalbarrels.item.BarrelUpgradeItem;
import tfar.metalbarrels.util.ModTags;
import tfar.metalbarrels.util.UpgradeInfo;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    public void buildRecipes(RecipeOutput consumer) {
        for (Map.Entry<String, BarrelUpgradeItem> entry : ModItems.upgrade_items.entrySet()) {
            BarrelUpgradeItem item = entry.getValue();
            UpgradeInfo info = item.getUpgradeInfo();
            String st = entry.getKey().split("_")[0];
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)info.end_block()).requires(ModTags.Items.tag("barrels/" + st)).requires((ItemLike)item).unlockedBy("has_" + st, ModRecipeProvider.has(ModTags.Items.tag("barrels/" + st))).save(consumer, MetalBarrels.id("upgrades/combine/" + entry.getKey()));
        }
        ModRecipeProvider.cheapNetheriteSmithing(consumer, ModBlocks.OBSIDIAN_BARREL.asItem(), RecipeCategory.DECORATIONS, ModBlocks.NETHERITE_BARREL.asItem());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.COPPER_BARREL).define(Character.valueOf('b'), Tags.Items.BARRELS_WOODEN).define(Character.valueOf('g'), Tags.Items.INGOTS_COPPER).pattern("gbg").unlockedBy("has_barrel", ModRecipeProvider.has((TagKey)Tags.Items.BARRELS_WOODEN)).save(consumer, MetalBarrels.id("barrels/wood_to_copper_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.IRON_BARREL).define(Character.valueOf('b'), Tags.Items.BARRELS_WOODEN).define(Character.valueOf('g'), Tags.Items.INGOTS_IRON).pattern(" g ").pattern("gbg").pattern(" g ").unlockedBy("has_barrel", ModRecipeProvider.has((TagKey)Tags.Items.BARRELS_WOODEN)).save(consumer, MetalBarrels.id("barrels/wood_to_iron_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.GOLD_BARREL).define(Character.valueOf('b'), Tags.Items.BARRELS_WOODEN).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).pattern("gig").pattern("ibi").pattern("gig").unlockedBy("has_barrel", ModRecipeProvider.has((TagKey)Tags.Items.BARRELS_WOODEN)).save(consumer, MetalBarrels.id("barrels/wood_to_gold_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.IRON_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.COPPER_BARREL).define(Character.valueOf('g'), Tags.Items.INGOTS_IRON).pattern("gbg").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.COPPER_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.COPPER_BARREL)).save(consumer, MetalBarrels.id("barrels/copper_to_iron_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.SILVER_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.IRON_BARREL).define(Character.valueOf('g'), ModTags.Items.INGOTS_SILVER).pattern("gbg").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.IRON_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.IRON_BARREL)).save(consumer, MetalBarrels.id("barrels/iron_to_silver_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.GOLD_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.SILVER_BARREL).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).pattern("gbg").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.SILVER_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.SILVER_BARREL)).save(consumer, MetalBarrels.id("barrels/silver_to_gold_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.GOLD_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.IRON_BARREL).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).pattern(" g ").pattern("gbg").pattern(" g ").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.IRON_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.IRON_BARREL)).save(consumer, MetalBarrels.id("barrels/iron_to_gold_barrel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.DIAMOND_BARREL).requires((ItemLike)ModBlocks.GOLD_BARREL).requires(Tags.Items.GEMS_DIAMOND).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.GOLD_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.GOLD_BARREL)).save(consumer, MetalBarrels.id("barrels/gold_to_diamond_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.DIAMOND_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.SILVER_BARREL).define(Character.valueOf('g'), Tags.Items.GEMS_DIAMOND).pattern("gbg").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.SILVER_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.SILVER_BARREL)).save(consumer, MetalBarrels.id("barrels/silver_to_diamond_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.CRYSTAL_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.DIAMOND_BARREL).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS_COLORLESS).pattern(" g ").pattern("gbg").pattern(" g ").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.DIAMOND_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.DIAMOND_BARREL)).save(consumer, MetalBarrels.id("barrels/diamond_to_crystal_barrel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.OBSIDIAN_BARREL).define(Character.valueOf('b'), (ItemLike)ModBlocks.DIAMOND_BARREL).define(Character.valueOf('g'), Tags.Items.OBSIDIANS).pattern(" g ").pattern("gbg").pattern(" g ").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModBlocks.DIAMOND_BARREL), ModRecipeProvider.has((ItemLike)ModBlocks.DIAMOND_BARREL)).save(consumer, MetalBarrels.id("barrels/diamond_to_obsidian_barrel"));
    }

    protected static void cheapNetheriteSmithing(RecipeOutput pFinishedRecipeConsumer, Item pIngredientItem, RecipeCategory pCategory, Item pResultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredientItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)pCategory, (Item)pResultItem).unlocks("has_netherite_ingot", ModRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).save(pFinishedRecipeConsumer, MetalBarrels.id(ModRecipeProvider.getItemName((ItemLike)pResultItem) + "_smithing"));
    }
}

