/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.metalbarrels.init.ModMenuTypes;
import tfar.metalbarrels.platform.Services;
import tfar.metalbarrels.util.BarrelHandler;

public class MetalBarrelMenu<H extends BarrelHandler>
extends AbstractContainerMenu {
    public int width;
    public int height;
    public final H handler;

    public MetalBarrelMenu(MenuType<?> containerType, int id, Inventory playerInventory, int width, int height, int containerX, int containerY, int playerX, int playerY, H handler) {
        super(containerType, id);
        int j;
        int i;
        this.width = width;
        this.height = height;
        if (handler == null) {
            handler = Services.PLATFORM.makeDummy(width * height);
        }
        this.handler = handler;
        handler.$startOpen(playerInventory.player);
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.addSlot(handler.addInvSlot(j + width * i, containerX + j * 18, containerY + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, j * 18 + playerX, i * 18 + playerY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, i * 18 + playerX, playerY + 58));
        }
    }

    public static MetalBarrelMenu copper(int id, Inventory playerInventory) {
        return MetalBarrelMenu.copperS(id, playerInventory, null);
    }

    public static MetalBarrelMenu iron(int id, Inventory playerInventory) {
        return MetalBarrelMenu.ironS(id, playerInventory, null);
    }

    public static MetalBarrelMenu silver(int id, Inventory playerInventory) {
        return MetalBarrelMenu.silverS(id, playerInventory, null);
    }

    public static MetalBarrelMenu gold(int id, Inventory playerInventory) {
        return MetalBarrelMenu.goldS(id, playerInventory, null);
    }

    public static MetalBarrelMenu diamond(int id, Inventory playerInventory) {
        return MetalBarrelMenu.diamondS(id, playerInventory, null);
    }

    public static MetalBarrelMenu netherite(int id, Inventory playerInventory) {
        return MetalBarrelMenu.netheriteS(id, playerInventory, null);
    }

    public static MetalBarrelMenu copperS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.COPPER, id, playerInventory, 9, 5, 8, 18, 8, 122, handler);
    }

    public static MetalBarrelMenu ironS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.IRON, id, playerInventory, 9, 6, 8, 18, 8, 140, handler);
    }

    public static MetalBarrelMenu silverS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.SILVER, id, playerInventory, 9, 8, 8, 18, 8, 176, handler);
    }

    public static MetalBarrelMenu goldS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.GOLD, id, playerInventory, 9, 9, 8, 18, 8, 194, handler);
    }

    public static MetalBarrelMenu diamondS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.DIAMOND, id, playerInventory, 12, 9, 8, 18, 35, 194, handler);
    }

    public static MetalBarrelMenu netheriteS(int id, Inventory playerInventory, BarrelHandler handler) {
        return new MetalBarrelMenu<BarrelHandler>(ModMenuTypes.NETHERITE, id, playerInventory, 15, 9, 8, 18, 62, 194, handler);
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.height * this.width ? !this.moveItemStackTo(itemstack1, this.height * this.width, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.height * this.width, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.handler.$stopOpen(playerIn);
    }
}

