/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookOrCondition
extends BookCondition {
    protected BookCondition[] children;
    protected List<Component> tooltips;

    public BookOrCondition(Component component, BookCondition[] children) {
        super(component);
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("OrCondition must have at least one child.");
        }
        this.children = children;
    }

    public static BookOrCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        ArrayList<BookCondition> children = new ArrayList<BookCondition>();
        for (JsonElement j : GsonHelper.getAsJsonArray((JsonObject)json, (String)"children")) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Condition children must be an array of JsonObjects.");
            }
            children.add(BookCondition.fromJson(conditionParentId, j.getAsJsonObject(), provider));
        }
        MutableComponent tooltip = BookOrCondition.tooltipFromJson(json, provider);
        return new BookOrCondition((Component)tooltip, children.toArray(new BookCondition[children.size()]));
    }

    public static BookOrCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        int childCount = buffer.readVarInt();
        BookCondition[] children = new BookCondition[childCount];
        for (int i = 0; i < childCount; ++i) {
            children[i] = BookCondition.fromNetwork(buffer);
        }
        return new BookOrCondition(tooltip, children);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.OR;
    }

    @Override
    public boolean requiresMultiPassUnlockTest() {
        return Arrays.stream(this.children).anyMatch(BookCondition::requiresMultiPassUnlockTest);
    }

    public BookCondition[] children() {
        return this.children;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeVarInt(this.children.length);
        for (BookCondition child : this.children) {
            BookCondition.toNetwork(child, buffer);
        }
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        for (BookCondition child : this.children) {
            if (!child.test(context, player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testOnLoad() {
        for (BookCondition child : this.children) {
            if (!child.testOnLoad()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<Component>();
        }
        this.tooltips.clear();
        if (this.tooltip != null) {
            this.tooltips.add(this.tooltip);
        }
        for (BookCondition child : this.children) {
            this.tooltips.addAll(child.getTooltip(player, context));
        }
        return this.tooltips;
    }
}

